/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.damagesource.HomeostaticDamageTypes;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.TemperatureThreshold;
import homeostatic.network.ITemperature;
import homeostatic.util.DamageHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_7923;

public class Temperature
implements ITemperature {
    private float skinTemperature;
    private float lastSkinTemperature;
    private float coreTemperature;
    private float localTemperature;

    public Temperature() {
        this.skinTemperature = TemperatureThreshold.NORMAL.temperature;
        this.lastSkinTemperature = TemperatureThreshold.NORMAL.temperature;
        this.coreTemperature = TemperatureThreshold.NORMAL.temperature;
        this.localTemperature = 0.0f;
    }

    @Override
    public void setSkinTemperature(float skinTemperature) {
        this.skinTemperature = skinTemperature;
    }

    @Override
    public void setLastSkinTemperature(float lastSkinTemperature) {
        this.lastSkinTemperature = lastSkinTemperature;
    }

    @Override
    public void setCoreTemperature(float coreTemperature) {
        this.coreTemperature = coreTemperature;
    }

    @Override
    public void setLocalTemperature(float temperature) {
        this.localTemperature = temperature;
    }

    @Override
    public void setTemperatureData(float localTemperature, BodyTemperature bodyTemperature) {
        this.setSkinTemperature(bodyTemperature.getSkinTemperature());
        this.setLastSkinTemperature(bodyTemperature.getLastSkinTemperature());
        this.setCoreTemperature(bodyTemperature.getCoreTemperature());
        this.setLocalTemperature(localTemperature);
    }

    @Override
    public float getSkinTemperature() {
        return this.skinTemperature;
    }

    @Override
    public float getLastSkinTemperature() {
        return this.lastSkinTemperature;
    }

    @Override
    public float getCoreTemperature() {
        return this.coreTemperature;
    }

    @Override
    public float getLocalTemperature() {
        return this.localTemperature;
    }

    @Override
    public void checkTemperatureLevel(class_1657 player) {
        float amount;
        if (this.coreTemperature < TemperatureThreshold.LOW.temperature && !player.method_6059(class_7923.field_41174.method_47983((Object)HomeostaticEffects.FROST_RESISTANCE))) {
            player.method_32317(player.method_32312() + 5);
        } else if (this.coreTemperature > TemperatureThreshold.HIGH.temperature) {
            amount = (1.0f + (this.coreTemperature - TemperatureThreshold.HIGH.temperature)) * 0.5f;
            player.method_5643(new class_1282(DamageHelper.getHolder(player.method_5682(), HomeostaticDamageTypes.HYPERTHERMIA)), amount);
        }
        if (this.skinTemperature > TemperatureThreshold.SCALDING.temperature) {
            amount = (1.0f + (this.skinTemperature - TemperatureThreshold.SCALDING.temperature)) * 0.25f;
            player.method_5643(new class_1282(DamageHelper.getHolder(player.method_5682(), HomeostaticDamageTypes.SCALDING)), amount);
        }
    }

    @Override
    public class_2499 write() {
        class_2499 listTag = new class_2499();
        class_2487 tag = new class_2487();
        this.write(tag);
        listTag.add((Object)tag);
        return listTag;
    }

    @Override
    public class_2487 write(class_2487 tag) {
        tag.method_10548("skinTemperature", this.getSkinTemperature());
        tag.method_10548("lastSkinTemperature", this.getLastSkinTemperature());
        tag.method_10548("coreTemperature", this.getCoreTemperature());
        tag.method_10548("localTemperature", this.getLocalTemperature());
        return tag;
    }

    @Override
    public void read(class_2499 nbt) {
        this.read(nbt.method_10602(0));
    }

    @Override
    public void read(class_2487 tag) {
        this.setSkinTemperature(tag.method_10583("skinTemperature"));
        this.setLastSkinTemperature(tag.method_10583("lastSkinTemperature"));
        this.setCoreTemperature(tag.method_10583("coreTemperature"));
        this.setLocalTemperature(tag.method_10583("localTemperature"));
    }
}

