/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.damagesource.HomeostaticDamageTypes;
import homeostatic.common.water.WaterInfo;
import homeostatic.network.IWater;
import homeostatic.util.DamageHelper;
import net.minecraft.class_1282;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3222;

public class Water
implements IWater {
    private int waterLevel = 20;
    private float waterSaturationLevel = 5.0f;
    private float waterExhaustionLevel = 0.0f;

    @Override
    public void setWaterLevel(int waterLevel) {
        this.waterLevel = waterLevel;
    }

    @Override
    public void increaseWaterLevel(int level) {
        this.waterLevel = Math.min(this.waterLevel + level, 20);
    }

    @Override
    public void increaseSaturationLevel(float level) {
        this.waterSaturationLevel = Math.min(this.waterSaturationLevel + level, 5.0f);
    }

    @Override
    public void setWaterSaturationLevel(float waterSaturationLevel) {
        this.waterSaturationLevel = waterSaturationLevel;
    }

    @Override
    public void setWaterExhaustionLevel(float waterExhaustionLevel) {
        this.waterExhaustionLevel = waterExhaustionLevel;
    }

    @Override
    public void setWaterData(WaterInfo waterInfo) {
        this.setWaterLevel(waterInfo.getWaterLevel());
        this.setWaterSaturationLevel(waterInfo.getWaterSaturationLevel());
        this.setWaterExhaustionLevel(waterInfo.getWaterExhaustionLevel());
    }

    @Override
    public int getWaterLevel() {
        return this.waterLevel;
    }

    @Override
    public float getWaterExhaustionLevel() {
        return this.waterExhaustionLevel;
    }

    @Override
    public float getWaterSaturationLevel() {
        return this.waterSaturationLevel;
    }

    @Override
    public void checkWaterLevel(class_3222 player) {
        if (this.waterLevel <= 0) {
            player.method_5643(new class_1282(DamageHelper.getHolder(player.method_5682(), HomeostaticDamageTypes.DEHYDRATION)), 0.5f);
        }
    }

    @Override
    public class_2499 write() {
        class_2499 listTag = new class_2499();
        class_2487 tag = new class_2487();
        this.write(tag);
        listTag.add((Object)tag);
        return listTag;
    }

    @Override
    public class_2487 write(class_2487 tag) {
        tag.method_10569("waterLevel", this.getWaterLevel());
        tag.method_10548("waterExhaustion", this.getWaterExhaustionLevel());
        tag.method_10548("waterSaturation", this.getWaterSaturationLevel());
        return tag;
    }

    @Override
    public void read(class_2499 nbt) {
        this.read(nbt.method_10602(0));
    }

    @Override
    public void read(class_2487 tag) {
        this.setWaterLevel(tag.method_10550("waterLevel"));
        this.setWaterExhaustionLevel(tag.method_10583("waterExhaustion"));
        this.setWaterSaturationLevel(tag.method_10583("waterSaturation"));
    }
}

