/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import homeostatic.Homeostatic;
import homeostatic.common.Hydration;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.overlay.Overlay;
import homeostatic.overlay.WaterHud;
import homeostatic.platform.Services;
import homeostatic.util.WaterHelper;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class HydrationOverlay
extends Overlay {
    public static final class_2960 SPRITE = Homeostatic.loc("textures/gui/icons.png");
    private static float unclampedAlpha = 0.0f;
    private static float alpha = 0.0f;
    private static byte alphaDirection = 1;
    protected static int tickCount = 0;

    @Override
    public void render(class_332 guiGraphics, class_310 mc, @Nullable class_2338 pos, int scaledWidth, int scaledHeight) {
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        class_1799 heldItem = player.method_6047();
        Hydration hydration = WaterHelper.getItemHydration(heldItem);
        if (hydration == null) {
            HydrationOverlay.resetAlpha();
            return;
        }
        class_329 gui = mc.field_1705;
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (class_2960)WaterHud.SPRITE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.blendFunc((int)770, (int)771);
        class_1293 effectInstance = mc.field_1724.method_6112(HomeostaticEffects.THIRST);
        Services.PLATFORM.getWaterCapabilty((class_1657)player).ifPresent(data -> {
            int waterLevel = data.getWaterLevel() + hydration.amount();
            float waterSaturationLevel = data.getWaterSaturationLevel() + hydration.saturation();
            WaterHelper.drawWaterBar(SPRITE, scaledWidth, scaledHeight, effectInstance, gui, guiGraphics, waterSaturationLevel, waterLevel, tickCount);
        });
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void onClientTick(class_310 minecraft) {
        if ((unclampedAlpha += (float)alphaDirection * 0.125f) >= 1.5f) {
            alphaDirection = (byte)-1;
        } else if (unclampedAlpha <= -0.5f) {
            alphaDirection = 1;
        }
        alpha = Math.max(0.0f, Math.min(1.0f, unclampedAlpha)) * Math.min(1.0f, 0.65f);
        ++tickCount;
        tickCount %= 1200;
    }

    public static void resetAlpha() {
        alpha = 0.0f;
        unclampedAlpha = 0.0f;
        alphaDirection = 1;
    }
}

