/*
 * Decompiled with CFR 0.152.
 */
package homeostatic;

import homeostatic.Homeostatic;
import homeostatic.HomeostaticClientNeoForge;
import homeostatic.common.CreativeTabs;
import homeostatic.common.HomeostaticModule;
import homeostatic.common.attachments.AttachmentsRegistry;
import homeostatic.common.block.HomeostaticBlocks;
import homeostatic.common.component.HomeostaticComponents;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.fluid.NeoForgeFluidType;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.potions.HomeostaticPotions;
import homeostatic.common.recipe.HomeostaticRecipes;
import homeostatic.event.ServerEventListener;
import homeostatic.network.DrinkWater;
import homeostatic.network.NeoForgeNetworkManager;
import homeostatic.network.NeoForgeTemperatureData;
import homeostatic.network.NeoForgeThermometerData;
import homeostatic.network.NeoForgeWaterData;
import homeostatic.network.NeoForgeWetnessData;
import homeostatic.registries.HomeostaticNeoForgeRegistries;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="homeostatic")
public class HomeostaticNeoForge {
    public HomeostaticNeoForge(IEventBus bus) {
        this.registryInit(bus);
        bus.register(RegistryListener.class);
        bus.addListener(this::setup);
        bus.addListener(this::registerPayloadHandler);
        Homeostatic.init();
        Homeostatic.initConfig();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            HomeostaticClientNeoForge.init(bus);
        }
        HomeostaticModule.initRegistries(bus);
    }

    private void setup(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register(ServerEventListener.class);
    }

    private void registryInit(IEventBus bus) {
        AttachmentsRegistry.init(bus);
        HomeostaticNeoForge.bind(bus, Registries.BLOCK, HomeostaticBlocks::init);
        HomeostaticNeoForge.bind(bus, Registries.MOB_EFFECT, HomeostaticEffects::init);
        HomeostaticNeoForge.bind(bus, Registries.FLUID, HomeostaticFluids::init);
        HomeostaticNeoForge.bind(bus, Registries.RECIPE_SERIALIZER, HomeostaticRecipes::init);
        HomeostaticNeoForge.bind(bus, Registries.ITEM, HomeostaticItems::init);
        HomeostaticNeoForge.bind(bus, Registries.POTION, HomeostaticPotions::init);
        HomeostaticNeoForgeRegistries.COMPONENT_TYPE_DEFERRED_REGISTER.register(bus);
        HomeostaticComponents.registerDataComponents();
    }

    private void registerPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("homeostatic").versioned("1.0");
        registrar.playToServer(DrinkWater.TYPE, DrinkWater.STREAM_CODEC, NeoForgeNetworkManager.getInstance()::processDrinkWater);
        registrar.playToClient(NeoForgeTemperatureData.TYPE, NeoForgeTemperatureData.STREAM_CODEC, NeoForgeNetworkManager.getInstance()::processTemperatureData);
        registrar.playToClient(NeoForgeThermometerData.TYPE, NeoForgeThermometerData.STREAM_CODEC, NeoForgeNetworkManager.getInstance()::processThermometerData);
        registrar.playToClient(NeoForgeWaterData.TYPE, NeoForgeWaterData.STREAM_CODEC, NeoForgeNetworkManager.getInstance()::processWaterData);
        registrar.playToClient(NeoForgeWetnessData.TYPE, NeoForgeWetnessData.STREAM_CODEC, NeoForgeNetworkManager.getInstance()::processWetnessData);
    }

    private static <T> void bind(IEventBus bus, ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        bus.addListener(event -> {
            if (registry.equals(event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    public static final class RegistryListener {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerEvent(RegisterEvent event) {
            event.register(NeoForgeRegistries.FLUID_TYPES.key(), NeoForgeFluidType::initTypes);
            if (event.getRegistryKey().equals(Registries.CREATIVE_MODE_TAB)) {
                CreativeTabs.init();
            }
        }
    }
}

