/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.recipe;

import com.google.common.collect.Lists;
import homeostatic.common.component.HomeostaticComponents;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.recipe.HomeostaticRecipes;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class HelmetThermometer
extends CustomRecipe {
    public HelmetThermometer(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput craftingInput, @NotNull Level level) {
        ItemStack armor = this.checkContainer(craftingInput);
        return armor != null;
    }

    public ItemStack assemble(@NotNull CraftingInput craftingInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ItemStack armorCopy = this.checkContainer(craftingInput).copy();
        CompoundTag tags = ((CustomData)armorCopy.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
        tags.putBoolean("thermometer", true);
        armorCopy.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)tags));
        return armorCopy;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return HomeostaticRecipes.HELMET_THERMOMETER_SERIALIZER;
    }

    public ItemStack checkContainer(CraftingInput craftingInput) {
        ArrayList ingredients = Lists.newArrayList();
        ItemStack armor = null;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ArmorItem armorItem;
            ItemStack ingredient = craftingInput.getItem(i);
            if (ingredient.is(HomeostaticItems.THERMOMETER)) {
                ingredients.add(ingredient);
                continue;
            }
            Item item = ingredient.getItem();
            if (!(item instanceof ArmorItem) || (armorItem = (ArmorItem)item).getEquipmentSlot() != EquipmentSlot.HEAD) continue;
            armor = ingredient;
        }
        if (ingredients.size() == 1 && armor != null) {
            return armor;
        }
        return null;
    }
}

