/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.config;

import homeostatic.common.Translations;
import homeostatic.util.Alignment;
import homeostatic.util.ColorHelper;
import java.awt.Color;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public class ConfigHandler {
    public static boolean loaded = false;
    public static final WhiteNoiseConfigSpec CLIENT_SPEC;
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Client CLIENT;
    private static final Common COMMON;

    private static String getTranslation(String key) {
        return Translations.get(key);
    }

    private static String getTranslation(String key, String ... values) {
        return Translations.get(key, values);
    }

    static {
        Pair specPairClient = new WhiteNoiseConfigSpec.Builder().configure(Client::new);
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        CLIENT_SPEC = (WhiteNoiseConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static final class Client {
        private static Color temperatureColorCold = ColorHelper.decode("#3ab3da");
        private static Color temperatureColorHot = ColorHelper.decode("#f9801d");
        private static final Predicate<Object> hexRangeValidator = s -> s instanceof String && ((String)s).matches("#[a-fA-F\\d]{6}->#[a-fA-F\\d]{6}");
        public final WhiteNoiseConfigSpec.BooleanValue useFahrenheit;
        public final WhiteNoiseConfigSpec.BooleanValue showDegreeSymbol;
        public final WhiteNoiseConfigSpec.EnumValue<Alignment.AlignmentType> debugPosition;
        public final WhiteNoiseConfigSpec.IntValue debugOffsetX;
        public final WhiteNoiseConfigSpec.IntValue debugOffsetY;
        public final WhiteNoiseConfigSpec.DoubleValue scale;
        public final WhiteNoiseConfigSpec.ConfigValue<String> temperatureColorRange;
        public final WhiteNoiseConfigSpec.EnumValue<Alignment.AlignmentType> globePosition;
        public final WhiteNoiseConfigSpec.IntValue globeOffsetX;
        public final WhiteNoiseConfigSpec.IntValue globeOffsetY;
        public final WhiteNoiseConfigSpec.IntValue globeTextOffsetY;
        public final WhiteNoiseConfigSpec.BooleanValue forceWaterBarPosition;
        public final WhiteNoiseConfigSpec.EnumValue<Alignment.AlignmentType> waterBarPosition;
        public final WhiteNoiseConfigSpec.IntValue waterBarOffsetX;
        public final WhiteNoiseConfigSpec.IntValue waterBarOffsetY;

        Client(WhiteNoiseConfigSpec.Builder builder) {
            this.useFahrenheit = builder.comment(ConfigHandler.getTranslation("usefahrenheit")).define("useFahrenheit", true);
            this.showDegreeSymbol = builder.comment(ConfigHandler.getTranslation("showdegreesymbol")).define("showDegreeSymbol", true);
            this.debugPosition = builder.comment(ConfigHandler.getTranslation("position")).defineEnum("position", (Enum)Alignment.AlignmentType.TOPRIGHT);
            this.debugOffsetX = builder.comment(ConfigHandler.getTranslation("debugoffsetx")).defineInRange("debugOffsetX", 3, -100, 100);
            this.debugOffsetY = builder.comment(ConfigHandler.getTranslation("debugoffsety")).defineInRange("debugOffsetY", 3, -100, 100);
            this.scale = builder.comment(ConfigHandler.getTranslation("scale")).defineInRange("scale", 0.5, 0.5, 2.0);
            this.temperatureColorRange = builder.comment(ConfigHandler.getTranslation("temperaturecolorrange")).define("temperatureColorRange", (Object)"#3ab3da->#f9801d", hexRangeValidator);
            this.globePosition = builder.comment(ConfigHandler.getTranslation("globeposition")).defineEnum("globePosition", (Enum)Alignment.AlignmentType.BOTTOMCENTER);
            this.globeOffsetX = builder.comment(ConfigHandler.getTranslation("globeoffsetx")).defineInRange("globeOffsetX", 0, -500, 500);
            this.globeOffsetY = builder.comment(ConfigHandler.getTranslation("globeoffsety")).defineInRange("globeOffsetY", 50, -500, 500);
            this.globeTextOffsetY = builder.comment(ConfigHandler.getTranslation("globetextoffsety")).defineInRange("globeTextOffsetY", 90, -500, 500);
            this.forceWaterBarPosition = builder.comment(ConfigHandler.getTranslation("forcewaterbarposition")).define("forceWaterBarPosition", false);
            this.waterBarPosition = builder.comment(ConfigHandler.getTranslation("waterbarposition")).defineEnum("waterBarPosition", (Enum)Alignment.AlignmentType.BOTTOMCENTER);
            this.waterBarOffsetX = builder.comment(ConfigHandler.getTranslation("waterbaroffsetx")).defineInRange("waterBarOffsetX", 96, -500, 500);
            this.waterBarOffsetY = builder.comment(ConfigHandler.getTranslation("waterbaroffsety")).defineInRange("waterBarOffsetY", 50, -500, 500);
        }

        public static boolean useFahrenheit() {
            return (Boolean)ConfigHandler.CLIENT.useFahrenheit.get();
        }

        public static boolean showDegreeSymbol() {
            return (Boolean)ConfigHandler.CLIENT.showDegreeSymbol.get();
        }

        public static Alignment.AlignmentType debugPosition() {
            return (Alignment.AlignmentType)((Object)ConfigHandler.CLIENT.debugPosition.get());
        }

        public static int debugOffsetX() {
            return (Integer)ConfigHandler.CLIENT.debugOffsetX.get();
        }

        public static int debugOffsetY() {
            return (Integer)ConfigHandler.CLIENT.debugOffsetY.get();
        }

        public static double scale() {
            return (Double)ConfigHandler.CLIENT.scale.get();
        }

        public static Color temperatureColorCold() {
            return temperatureColorCold;
        }

        public static Color temperatureColorHot() {
            return temperatureColorHot;
        }

        public static Alignment.AlignmentType globePosition() {
            return (Alignment.AlignmentType)((Object)ConfigHandler.CLIENT.globePosition.get());
        }

        public static int globeOffsetX() {
            return (Integer)ConfigHandler.CLIENT.globeOffsetX.get();
        }

        public static int globeOffsetY() {
            return (Integer)ConfigHandler.CLIENT.globeOffsetY.get();
        }

        public static int globeTextOffsetY() {
            return (Integer)ConfigHandler.CLIENT.globeTextOffsetY.get();
        }

        public static boolean forceWaterBarPosition() {
            return (Boolean)ConfigHandler.CLIENT.forceWaterBarPosition.get();
        }

        public static Alignment.AlignmentType waterBarPosition() {
            return (Alignment.AlignmentType)((Object)ConfigHandler.CLIENT.waterBarPosition.get());
        }

        public static int waterBarOffsetX() {
            return (Integer)ConfigHandler.CLIENT.waterBarOffsetX.get();
        }

        public static int waterBarOffsetY() {
            return (Integer)ConfigHandler.CLIENT.waterBarOffsetY.get();
        }

        public static void init() {
            String[] temperatureColors = ((String)ConfigHandler.CLIENT.temperatureColorRange.get()).split("->");
            temperatureColorCold = ColorHelper.decode(temperatureColors[0]);
            temperatureColorHot = ColorHelper.decode(temperatureColors[1]);
            loaded = true;
        }
    }

    public static final class Common {
        public final WhiteNoiseConfigSpec.BooleanValue debugEnabled;
        public final WhiteNoiseConfigSpec.BooleanValue showTemperatureValues;
        public final WhiteNoiseConfigSpec.BooleanValue requireThermometer;
        public final WhiteNoiseConfigSpec.DoubleValue randomWaterLoss;
        public final WhiteNoiseConfigSpec.DoubleValue radiationReductionPercent;

        Common(WhiteNoiseConfigSpec.Builder builder) {
            this.debugEnabled = builder.comment(ConfigHandler.getTranslation("debugenabled")).define("debugEnabled", false);
            this.showTemperatureValues = builder.comment(ConfigHandler.getTranslation("showtemperaturevalues")).define("showTemperatureValues", true);
            this.requireThermometer = builder.comment(ConfigHandler.getTranslation("requirethermometer")).define("requireThermometer", false);
            this.randomWaterLoss = builder.comment(ConfigHandler.getTranslation("randomwaterloss")).defineInRange("randomWaterLoss", 0.15, 0.01, 1.0);
            this.radiationReductionPercent = builder.comment(ConfigHandler.getTranslation("radiationreductionpercent")).defineInRange("radiationReductionPercent", 0.2, 0.1, 1.0);
        }

        public static boolean debugEnabled() {
            return (Boolean)ConfigHandler.COMMON.debugEnabled.get();
        }

        public static boolean showTemperatureValues() {
            return (Boolean)ConfigHandler.COMMON.showTemperatureValues.get();
        }

        public static boolean requireThermometer() {
            return (Boolean)ConfigHandler.COMMON.requireThermometer.get();
        }

        public static float getRandomWaterLoss() {
            double waterLoss = (Double)ConfigHandler.COMMON.randomWaterLoss.get();
            return (float)waterLoss;
        }

        public static float getRadiationReductionPercent() {
            double reduction = (Double)ConfigHandler.COMMON.radiationReductionPercent.get();
            return (float)reduction;
        }
    }
}

