/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.integrations;

import homeostatic.Homeostatic;
import homeostatic.common.TagManager;
import homeostatic.common.component.HomeostaticComponents;
import homeostatic.util.RegistryHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public final class ArmorEnhancementRecipeMaker {
    public static List<RecipeHolder<CraftingRecipe>> createRecipes(String plugin) {
        String group = plugin + ".armor.enhancement";
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        Ingredient wool = Ingredient.of(TagManager.Items.INSULATION);
        Ingredient waterproof = Ingredient.of(TagManager.Items.WATERPROOF);
        Ingredient radiation = Ingredient.of(TagManager.Items.RADIATION_PROTECTION);
        RegistryHelper.getRegistry(Registries.ITEM).stream().filter(ArmorItem.class::isInstance).forEach(armorItem -> {
            Ingredient baseArmorIngredient = Ingredient.of((ItemLike[])new ItemLike[]{armorItem.asItem()});
            ItemStack woolArmorStack = new ItemStack((ItemLike)armorItem);
            ItemStack waterproofArmorStack = new ItemStack((ItemLike)armorItem);
            ItemStack radiationArmorStack = new ItemStack((ItemLike)armorItem);
            CompoundTag woolArmorStackTag = ((CustomData)woolArmorStack.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
            CompoundTag waterproofArmorStackTag = ((CustomData)waterproofArmorStack.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
            CompoundTag radiationArmorStackTag = ((CustomData)radiationArmorStack.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
            NonNullList insulatedInputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{baseArmorIngredient, wool, wool, wool});
            NonNullList waterproofInputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{baseArmorIngredient, waterproof, waterproof, waterproof});
            NonNullList radiationInputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{baseArmorIngredient, radiation, radiation, radiation});
            woolArmorStackTag.putBoolean("insulation", true);
            woolArmorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)woolArmorStackTag));
            recipes.add(new RecipeHolder(Homeostatic.prefix(group + ".insulated"), (Recipe)new ShapelessRecipe(group, CraftingBookCategory.EQUIPMENT, woolArmorStack, insulatedInputs)));
            waterproofArmorStackTag.putBoolean("waterproof", true);
            waterproofArmorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)waterproofArmorStackTag));
            recipes.add(new RecipeHolder(Homeostatic.prefix(group + ".waterproof"), (Recipe)new ShapelessRecipe(group, CraftingBookCategory.EQUIPMENT, waterproofArmorStack, waterproofInputs)));
            radiationArmorStackTag.putBoolean("radiation_protection", true);
            radiationArmorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)radiationArmorStackTag));
            recipes.add(new RecipeHolder(Homeostatic.prefix(group + ".radiation_resistance"), (Recipe)new ShapelessRecipe(group, CraftingBookCategory.EQUIPMENT, radiationArmorStack, radiationInputs)));
        });
        return recipes;
    }
}

