/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.Homeostatic;
import homeostatic.common.water.WaterInfo;
import homeostatic.platform.Services;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class WaterData {
    private final int waterLevel;
    private final float waterSaturationLevel;
    private final float waterExhaustionLevel;
    private final WaterInfo waterInfo;
    public static final ResourceLocation ID = Homeostatic.prefix("water_data");

    public WaterData(WaterInfo waterInfo) {
        this.waterLevel = waterInfo.getWaterLevel();
        this.waterSaturationLevel = waterInfo.getWaterSaturationLevel();
        this.waterExhaustionLevel = waterInfo.getWaterExhaustionLevel();
        this.waterInfo = waterInfo;
    }

    public WaterData(FriendlyByteBuf buf) {
        this.waterLevel = buf.readInt();
        this.waterSaturationLevel = buf.readFloat();
        this.waterExhaustionLevel = buf.readFloat();
        this.waterInfo = new WaterInfo(this.waterLevel, this.waterSaturationLevel, this.waterExhaustionLevel);
    }

    public WaterInfo getWaterInfo() {
        return this.waterInfo;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.waterLevel);
        buf.writeFloat(this.waterSaturationLevel);
        buf.writeFloat(this.waterExhaustionLevel);
    }

    public static void process(Player player, CompoundTag tag) {
        Services.PLATFORM.getWaterCapabilty(player).ifPresent(data -> data.read(tag));
    }
}

