/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.config.ConfigHandler;
import homeostatic.overlay.EnhancedVisualsOverlay;
import homeostatic.overlay.HydrationOverlay;
import homeostatic.overlay.Overlay;
import homeostatic.overlay.TemperatureGlobeOverlay;
import homeostatic.overlay.TemperatureInfo;
import homeostatic.overlay.WaterHud;
import homeostatic.overlay.WetnessOverlay;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;

public class OverlayManager {
    public static final OverlayManager INSTANCE = new OverlayManager();
    public final WaterHud waterHud = new WaterHud();
    public final WetnessOverlay wetnessOverlay = new WetnessOverlay();
    public final TemperatureGlobeOverlay temperatureGlobeOverlay = new TemperatureGlobeOverlay();
    public final TemperatureInfo temperatureInfo = new TemperatureInfo();
    public final EnhancedVisualsOverlay enhancedVisualsOverlay = new EnhancedVisualsOverlay();
    public final HydrationOverlay hydrationOverlay = new HydrationOverlay();

    private OverlayManager() {
    }

    public void render(GuiGraphics guiGraphics, Overlay overlay, boolean scaled, int rightHeight) {
        PoseStack matrix = guiGraphics.pose();
        Minecraft mc = Minecraft.getInstance();
        BlockPos pos = Objects.requireNonNull(mc.getCameraEntity()).blockPosition();
        if (mc.level != null && mc.level.isLoaded(pos)) {
            int scaledHeight;
            int scaledWidth;
            if (scaled) {
                float scale = (float)ConfigHandler.Client.scale();
                scaledWidth = (int)((float)mc.getWindow().getGuiScaledWidth() / scale);
                scaledHeight = (int)((float)mc.getWindow().getGuiScaledHeight() / scale);
                matrix.pushPose();
                matrix.scale(scale, scale, scale);
            } else {
                scaledWidth = mc.getWindow().getGuiScaledWidth();
                scaledHeight = mc.getWindow().getGuiScaledHeight() - rightHeight;
                matrix.pushPose();
            }
            overlay.render(guiGraphics, mc, pos, scaledWidth, scaledHeight);
            matrix.popPose();
        }
    }

    public void renderOverlay(GuiGraphics guiGraphics) {
        this.render(guiGraphics, this.temperatureInfo, true, 0);
    }

    public void renderWaterOverlay(GuiGraphics guiGraphics, int rightHeight) {
        if (ConfigHandler.Client.forceWaterBarPosition()) {
            rightHeight = 0;
        }
        this.render(guiGraphics, this.waterHud, false, rightHeight);
        this.render(guiGraphics, this.wetnessOverlay, false, 0);
    }

    public void renderTemperatureOverlay(GuiGraphics guiGraphics) {
        this.render(guiGraphics, this.temperatureGlobeOverlay, false, 0);
    }

    public void renderEnhancedVisualsOverlay(GuiGraphics guiGraphics) {
        this.render(guiGraphics, this.enhancedVisualsOverlay, false, 0);
    }

    public void renderHydrationOverlay(GuiGraphics guiGraphics, int rightHeight) {
        this.render(guiGraphics, this.hydrationOverlay, false, rightHeight);
    }
}

