/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class VecMath {
    public static double getDistance(ServerPlayer sp, Vector3d vPos) {
        double x = Math.max(0.0, Math.abs(sp.getX() - vPos.x) - (double)(sp.getBbWidth() / 2.0f));
        double y = Math.max(0.0, Math.abs(sp.getY() + (double)(sp.getBbHeight() / 2.0f) - vPos.y) - (double)(sp.getBbHeight() / 2.0f));
        double z = Math.max(0.0, Math.abs(sp.getZ() - vPos.z) - (double)(sp.getBbWidth() / 2.0f));
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static boolean isBlockObscured(ServerPlayer sp, Vec3 blockVec) {
        Vec3 playerVec = new Vec3(sp.getX(), sp.getEyeY(), sp.getZ());
        ClipContext clipContext = new ClipContext(playerVec, blockVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)sp);
        return sp.serverLevel().clip(clipContext).getType() != HitResult.Type.MISS;
    }
}

