/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.biome;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.biome.BiomeCategory;
import homeostatic.common.biome.BiomeCategoryManager;
import homeostatic.common.biome.BiomeTypeData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;

public class BiomeTypeDataManager
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, BiomeTypeData> BIOME_TYPES = new HashMap<ResourceLocation, BiomeTypeData>();
    private static final ResourceLocation MISSING_LOC = Homeostatic.loc(BiomeCategory.Type.MISSING.toString());
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BiomeTypeData.class, (Object)new BiomeTypeData.Serializer()).create();

    public BiomeTypeDataManager() {
        super(GSON, "environment/biome_type_data");
    }

    public static JsonElement parseBiomeData(BiomeTypeData biomeTypeData) {
        return GSON.toJsonTree((Object)biomeTypeData);
    }

    public static BiomeTypeData getBiomeData(ResourceLocation type) {
        return BIOME_TYPES.getOrDefault(type, BIOME_TYPES.get(MISSING_LOC));
    }

    public static BiomeTypeData getDataForBiome(Holder<Biome> biome) {
        ResourceLocation biomeCategory = Homeostatic.loc(BiomeCategoryManager.getBiomeCategory(biome).toString());
        return BiomeTypeDataManager.getBiomeData(biomeCategory);
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        BIOME_TYPES.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            try {
                BiomeTypeData biomeTypeData = (BiomeTypeData)GSON.fromJson(entry.getValue(), BiomeTypeData.class);
                BIOME_TYPES.put(entry.getKey(), biomeTypeData);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse biome data {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} biome types.", (Object)BIOME_TYPES.size());
    }
}

