/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.capabilities;

import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.capabilities.IWater;
import homeostatic.common.capabilities.Water;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterCapability
extends Water {
    public static LazyOptional<IWater> getCapability(Player player) {
        return player.getCapability(CapabilityRegistry.WATER_CAPABILITY);
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        @NotNull
        private final IWater instance = new Water();
        private final LazyOptional<IWater> handler = LazyOptional.of(this::getInstance);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CapabilityRegistry.WATER_CAPABILITY.orEmpty(cap, this.handler);
        }

        public IWater getInstance() {
            return this.instance;
        }

        public Tag serializeNBT() {
            return this.instance.write();
        }

        public void deserializeNBT(Tag nbt) {
            this.instance.read((CompoundTag)nbt);
        }
    }
}

