/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.TagManager;
import homeostatic.common.item.DrinkableItem;
import homeostatic.platform.Services;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class DrinkableItemManager
extends SimpleJsonResourceReloadListener {
    private static final Map<Item, DrinkableItem> ITEMS = new HashMap<Item, DrinkableItem>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DrinkableItem.class, (Object)new DrinkableItem.Serializer()).create();
    private static final DrinkableItem FRUIT = new DrinkableItem(TagManager.Items.FRUITS.f_203868_(), 2, 0.6f, 0, 0, 0.0f);
    private static final DrinkableItem ROOT_VEGETABLE = new DrinkableItem(TagManager.Items.ROOT_VEGETABLES.f_203868_(), 1, 0.1f, 0, 0, 0.0f);
    private static final DrinkableItem VEGETABLE = new DrinkableItem(TagManager.Items.VEGETABLES.f_203868_(), 1, 0.1f, 0, 0, 0.0f);
    private static final DrinkableItem FRUIT_COMMON = new DrinkableItem(TagManager.Items.FRUITS_COMMON.f_203868_(), 2, 0.6f, 0, 0, 0.0f);
    private static final DrinkableItem ROOT_VEGETABLE_COMMON = new DrinkableItem(TagManager.Items.ROOT_VEGETABLES_COMMON.f_203868_(), 1, 0.1f, 0, 0, 0.0f);
    private static final DrinkableItem VEGETABLE_COMMON = new DrinkableItem(TagManager.Items.VEGETABLES_COMMON.f_203868_(), 1, 0.1f, 0, 0, 0.0f);

    public DrinkableItemManager() {
        super(GSON, "environment/drinkable");
    }

    public static JsonElement parseDrinkableItem(DrinkableItem drinkableItem) {
        return GSON.toJsonTree((Object)drinkableItem);
    }

    public static DrinkableItem get(ItemStack stack) {
        DrinkableItem drinkableItem = ITEMS.get(stack.m_41720_());
        if (drinkableItem != null) {
            return drinkableItem;
        }
        if (stack.m_204117_(TagManager.Items.FRUITS)) {
            return FRUIT;
        }
        if (stack.m_204117_(TagManager.Items.FRUITS_COMMON)) {
            return FRUIT_COMMON;
        }
        if (stack.m_204117_(TagManager.Items.ROOT_VEGETABLES)) {
            return ROOT_VEGETABLE;
        }
        if (stack.m_204117_(TagManager.Items.ROOT_VEGETABLES_COMMON)) {
            return ROOT_VEGETABLE_COMMON;
        }
        if (stack.m_204117_(TagManager.Items.VEGETABLES)) {
            return VEGETABLE;
        }
        if (stack.m_204117_(TagManager.Items.VEGETABLES_COMMON)) {
            return VEGETABLE_COMMON;
        }
        return null;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        ITEMS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            try {
                DrinkableItem drinkableItem = (DrinkableItem)GSON.fromJson(entry.getValue(), DrinkableItem.class);
                Item item = Services.PLATFORM.getItem(drinkableItem.loc());
                if (item == Items.f_41852_ || item == null) continue;
                ITEMS.put(item, drinkableItem);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse drinkable item {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} drinkable items", (Object)ITEMS.size());
    }
}

