/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.event;

import homeostatic.common.biome.BiomeCategoryManager;
import homeostatic.common.biome.BiomeTypeDataManager;
import homeostatic.common.block.BlockRadiationManager;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.fluid.DrinkingFluidManager;
import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.item.DrinkableItemManager;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.item.LeatherFlask;
import homeostatic.event.PlayerEventHandler;
import homeostatic.platform.Services;
import homeostatic.util.WaterHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ServerEventListener {
    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Player player;
        Player player2 = player = event.getEntity() instanceof Player ? (Player)event.getEntity() : null;
        if (player != null && !player.m_9236_().f_46443_) {
            PlayerEventHandler.onEntityJoinLevel((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof FakePlayer) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!event.player.m_9236_().m_5776_()) {
            PlayerEventHandler.onPlayerTickEvent((ServerPlayer)event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.Clone event) {
        Player player;
        if (!event.isWasDeath()) {
            return;
        }
        Player player2 = player = event.getEntity() != null ? event.getEntity() : null;
        if (player != null && !player.m_9236_().f_46443_) {
            PlayerEventHandler.onPlayerRespawn((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onFinishUsingItem(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_) {
                ItemStack stack = event.getItem();
                ServerPlayer sp = (ServerPlayer)player;
                WaterHelper.drink(sp, stack, true);
            }
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        PlayerEventHandler.onEquipmentChange(event.getEntity(), event.getSlot(), event.getFrom(), event.getTo());
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new BiomeCategoryManager());
        event.addListener((PreparableReloadListener)new BiomeTypeDataManager());
        event.addListener((PreparableReloadListener)new BlockRadiationManager());
        event.addListener((PreparableReloadListener)new DrinkingFluidManager());
        event.addListener((PreparableReloadListener)new DrinkableItemManager());
    }

    @SubscribeEvent
    public static void onStartUsingItem(LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_ && event.getItem().m_41720_() instanceof LeatherFlask) {
                ItemStack holding = event.getItem();
                int holdingCapacity = (int)Services.PLATFORM.getFluidCapacity(holding);
                FluidInfo fluidInfo = Services.PLATFORM.getFluidInfo(holding).get();
                if ((long)holdingCapacity != 1000L || fluidInfo.amount() > 1000L) {
                    ItemStack mainHandItem = player.m_21205_();
                    ItemStack offhandItem = player.m_21206_();
                    if (mainHandItem.m_41720_() instanceof LeatherFlask) {
                        player.m_8061_(EquipmentSlot.MAINHAND, ServerEventListener.stackFixerUpper(mainHandItem, new ItemStack((ItemLike)HomeostaticItems.LEATHER_FLASK)));
                    }
                    if (offhandItem.m_41720_() instanceof LeatherFlask) {
                        player.m_8061_(EquipmentSlot.MAINHAND, ServerEventListener.stackFixerUpper(offhandItem, new ItemStack((ItemLike)HomeostaticItems.LEATHER_FLASK)));
                    }
                }
            }
        }
    }

    @Deprecated
    private static ItemStack stackFixerUpper(ItemStack original, ItemStack replacement) {
        AtomicInteger currentAmount = new AtomicInteger(0);
        AtomicReference<FlowingFluid> currentFluid = new AtomicReference<FlowingFluid>(Fluids.f_76193_);
        original.getCapability(CapabilityRegistry.FLUID_ITEM_CAPABILITY).ifPresent(handler -> {
            currentFluid.set((FlowingFluid)handler.getFluidInTank(0).getFluid());
            currentAmount.set(handler.getTankCapacity(0));
        });
        return WaterHelper.getFilledItem(replacement, (Fluid)currentFluid.get(), currentAmount.get() / 5);
    }
}

