/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.platform;

import homeostatic.common.biome.ClimateSettings;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.capabilities.ITemperature;
import homeostatic.common.capabilities.IThermometer;
import homeostatic.common.capabilities.IWater;
import homeostatic.common.capabilities.IWetness;
import homeostatic.common.capabilities.TemperatureCapability;
import homeostatic.common.capabilities.ThermometerCapability;
import homeostatic.common.capabilities.WaterCapability;
import homeostatic.common.capabilities.WetnessCapability;
import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.EnvironmentData;
import homeostatic.common.temperature.SubSeason;
import homeostatic.common.temperature.ThermometerInfo;
import homeostatic.common.water.WaterInfo;
import homeostatic.common.wetness.WetnessInfo;
import homeostatic.mixin.ServerLevelAccessor;
import homeostatic.network.ForgeTemperatureData;
import homeostatic.network.ForgeThermometerData;
import homeostatic.network.ForgeWaterData;
import homeostatic.network.ForgeWetnessData;
import homeostatic.network.NetworkHandler;
import homeostatic.platform.Services;
import homeostatic.platform.services.IPlatform;
import homeostatic.util.CreateHelper;
import homeostatic.util.EclipticSeasonsHelper;
import homeostatic.util.SereneSeasonsHelper;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgePlatform
implements IPlatform {
    @Override
    public ResourceLocation getFluidResourceLocation(Fluid fluid) {
        return ForgeRegistries.FLUIDS.getKey((Object)fluid);
    }

    @Override
    public boolean isModLoaded(String name) {
        return technology.roughness.whitenoise.platform.Services.PLATFORM.isModLoaded(name);
    }

    @Override
    public double getCreateBlockRadiation(BlockState state, Double radiation) {
        return CreateHelper.getBlockRadiation(state, radiation);
    }

    @Override
    public Block getBlock(ResourceLocation loc) {
        return (Block)ForgeRegistries.BLOCKS.getValue(loc);
    }

    @Override
    public Fluid getFluid(ResourceLocation loc) {
        return (Fluid)ForgeRegistries.FLUIDS.getValue(loc);
    }

    @Override
    public Item getItem(ResourceLocation loc) {
        return (Item)ForgeRegistries.ITEMS.getValue(loc);
    }

    @Override
    public String fluidStackTag() {
        return "Fluid";
    }

    @Override
    public Optional<FluidInfo> getFluidInfo(ItemStack stack) {
        return stack.getCapability(CapabilityRegistry.FLUID_ITEM_CAPABILITY).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).map(fluidStack -> new FluidInfo(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.isEmpty() ? new CompoundTag() : fluidStack.getOrCreateTag()));
    }

    @Override
    public ItemStack drainFluid(ItemStack stack, long amount) {
        stack.getCapability(CapabilityRegistry.FLUID_ITEM_CAPABILITY).ifPresent(handler -> handler.drain((int)amount, IFluidHandler.FluidAction.EXECUTE));
        this.updateDamage(stack);
        return stack;
    }

    @Override
    public ItemStack fillFluid(ItemStack stack, Fluid fluid, long amount) {
        FluidStack fluidStack = new FluidStack(fluid, (int)amount);
        stack.getCapability(CapabilityRegistry.FLUID_ITEM_CAPABILITY).ifPresent(handler -> handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE));
        this.updateDamage(stack);
        return stack;
    }

    @Override
    public long getFluidCapacity(ItemStack stack) {
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityRegistry.FLUID_ITEM_CAPABILITY).orElse(null);
        return fluidHandlerItem.getTankCapacity(0);
    }

    @Override
    public Component getDisplayName(Fluid fluid) {
        FluidInfo fluidInfo = new FluidInfo(fluid);
        return fluid.getFluidType().getDescription(new FluidStack(fluidInfo.fluid(), (int)fluidInfo.amount()));
    }

    @Override
    public ClimateSettings getClimateSettings(Holder<Biome> biomeHolder) {
        Biome.ClimateSettings climateSettings = ((Biome)biomeHolder.m_203334_()).getModifiedClimateSettings();
        return new ClimateSettings(biomeHolder, climateSettings.f_263819_(), climateSettings.f_47681_(), climateSettings.f_47682_(), climateSettings.f_47683_());
    }

    @Override
    public SubSeason getSubSeason(ServerLevel level, Holder<Biome> biomeHolder) {
        if (Services.PLATFORM.isModLoaded("sereneseasons")) {
            return SereneSeasonsHelper.getSubSeason((Level)level);
        }
        if (Services.PLATFORM.isModLoaded("eclipticseasons")) {
            return EclipticSeasonsHelper.getSubSeason((Level)level);
        }
        return null;
    }

    @Override
    public Optional<? extends ITemperature> getTemperatureData(Player player) {
        return TemperatureCapability.getCapability(player).resolve();
    }

    @Override
    public void syncTemperatureData(ServerPlayer sp, EnvironmentData environmentData, BodyTemperature bodyTemperature) {
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new ForgeTemperatureData(environmentData.getLocalTemperature(), bodyTemperature));
    }

    @Override
    public Optional<? extends IThermometer> getThermometerCapability(Player player) {
        return ThermometerCapability.getCapability(player).resolve();
    }

    @Override
    public void syncThermometerData(ServerPlayer sp, ThermometerInfo info) {
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new ForgeThermometerData(info));
    }

    @Override
    public Optional<? extends IWater> getWaterCapabilty(Player player) {
        return WaterCapability.getCapability(player).resolve();
    }

    @Override
    public void syncWaterData(ServerPlayer sp, WaterInfo waterInfo) {
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new ForgeWaterData(waterInfo));
    }

    @Override
    public Optional<? extends IWetness> getWetnessCapability(Player player) {
        return WetnessCapability.getCapability(player).resolve();
    }

    @Override
    public void syncWetnessData(ServerPlayer sp, WetnessInfo wetnessInfo) {
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new ForgeWetnessData(wetnessInfo));
    }

    @Override
    public ServerLevelData getServerLevelData(ServerLevel level) {
        ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
        return serverLevel.getServerLevelData();
    }

    public void updateDamage(ItemStack stack) {
        if (stack.m_41763_()) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityRegistry.FLUID_ITEM_CAPABILITY).orElse(null);
            stack.m_41721_(Math.min(stack.m_41776_(), stack.m_41776_() - fluidHandlerItem.getFluidInTank(0).getAmount()));
        }
    }
}

