/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import homeostatic.common.fluid.FluidInfo;
import homeostatic.platform.Services;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import technology.roughness.whitenoise.util.ResourceLocationHelper;

public class ItemStackFluidHelper {
    public static FluidInfo getFluidInfo(ItemStack stack) {
        return new FluidInfo(ItemStackFluidHelper.getFluid(stack), ItemStackFluidHelper.getAmount(stack));
    }

    public static Fluid getFluid(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("homeostatic");
        if (!tag.m_128441_(Services.PLATFORM.fluidStackTag())) {
            ItemStackFluidHelper.setFluid(stack, Fluids.f_76191_);
        }
        String fluidName = tag.m_128461_(Services.PLATFORM.fluidStackTag());
        return Services.PLATFORM.getFluid(ResourceLocationHelper.mcLoc((String)fluidName));
    }

    public static void setFluid(ItemStack stack, Fluid fluid) {
        stack.m_41698_("homeostatic").m_128359_(Services.PLATFORM.fluidStackTag(), Services.PLATFORM.getFluidResourceLocation(fluid).toString());
    }

    public static void setAmount(ItemStack stack, Long amount) {
        CompoundTag tag = stack.m_41698_("homeostatic");
        tag.m_128356_("Amount", amount.longValue());
    }

    public static Long getAmount(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("homeostatic");
        if (!tag.m_128441_("Amount")) {
            ItemStackFluidHelper.setAmount(stack, 0L);
        }
        return tag.m_128454_("Amount");
    }

    public static void drainFluid(ItemStack stack, Long amount) {
        Long currentAmount = ItemStackFluidHelper.getAmount(stack);
        ItemStackFluidHelper.setAmount(stack, Math.max(0L, currentAmount - amount));
        ItemStackFluidHelper.updateDamage(stack);
    }

    public static void fillFluid(ItemStack stack, Fluid fluid, long amount) {
        ItemStackFluidHelper.setFluid(stack, fluid);
        ItemStackFluidHelper.setAmount(stack, amount);
        ItemStackFluidHelper.updateDamage(stack);
    }

    public static void updateDamage(ItemStack stack) {
        if (stack.m_41763_()) {
            FluidInfo fluidInfo = ItemStackFluidHelper.getFluidInfo(stack);
            if (stack.m_41763_()) {
                stack.m_41721_(Math.min(stack.m_41776_(), stack.m_41776_() - (int)fluidInfo.amount()));
            }
        }
    }
}

