/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.biome;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.biome.BiomeCategory;
import homeostatic.common.biome.BiomeCategoryManager;
import homeostatic.common.biome.BiomeTypeData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class BiomeTypeDataManager
extends class_4309 {
    private static final Map<class_2960, BiomeTypeData> BIOME_TYPES = new HashMap<class_2960, BiomeTypeData>();
    private static final class_2960 MISSING_LOC = Homeostatic.prefix(BiomeCategory.Type.MISSING.toString());
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BiomeTypeData.class, (Object)new BiomeTypeData.Serializer()).create();

    public BiomeTypeDataManager() {
        super(GSON, "environment/biome_type_data");
    }

    public static JsonElement parseBiomeData(BiomeTypeData biomeTypeData) {
        return GSON.toJsonTree((Object)biomeTypeData);
    }

    public static BiomeTypeData getBiomeData(class_2960 type) {
        return BIOME_TYPES.getOrDefault(type, BIOME_TYPES.get(MISSING_LOC));
    }

    public static BiomeTypeData getDataForBiome(class_6880<class_1959> biome) {
        class_2960 biomeCategory = Homeostatic.prefix(BiomeCategoryManager.getBiomeCategory(biome).toString());
        return BiomeTypeDataManager.getBiomeData(biomeCategory);
    }

    protected void apply(Map<class_2960, JsonElement> pObject, @NotNull class_3300 pResourceManager, @NotNull class_3695 pProfiler) {
        BIOME_TYPES.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            try {
                BiomeTypeData biomeTypeData = (BiomeTypeData)GSON.fromJson(entry.getValue(), BiomeTypeData.class);
                BIOME_TYPES.put(entry.getKey(), biomeTypeData);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse biome data {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} biome types.", (Object)BIOME_TYPES.size());
    }
}

