/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.biome.BiomeCategory;
import homeostatic.common.biome.BiomeTypeData;
import homeostatic.common.biome.BiomeTypeDataManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

public class BiomeTypeDataProvider
implements class_2405 {
    private final Map<class_2960, BiomeTypeData> BIOME_TYPES_MAP = new HashMap<class_2960, BiomeTypeData>();
    private final class_7784 packOutput;

    public BiomeTypeDataProvider(@NotNull class_7784 packOutput) {
        this.packOutput = packOutput;
    }

    protected void registerBiomeTypeData() {
        this.add(Homeostatic.prefix(BiomeCategory.Type.BOG.toString()), new BiomeTypeData(0.351f, 60.0, 40.0, 10.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.FROZEN_OCEAN.toString()), new BiomeTypeData(0.373f, 20.0, 20.0, 5.0, true));
        this.add(Homeostatic.prefix(BiomeCategory.Type.COLD_OCEAN.toString()), new BiomeTypeData(0.373f, 20.0, 20.0, 5.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.COLD_FOREST.toString()), new BiomeTypeData(0.373f, 60.0, 40.0, 12.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.COLD_DESERT.toString()), new BiomeTypeData(0.395f, 20.0, 40.0, 20.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.DEEP_COLD_OCEAN.toString()), new BiomeTypeData(0.44f, 20.0, 20.0, 5.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.ICY.toString()), new BiomeTypeData(0.507f, 20.0, 20.0, 5.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.TAIGA.toString()), new BiomeTypeData(0.507f, 50.0, 40.0, 10.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.OCEAN.toString()), new BiomeTypeData(0.551f, 70.0, 40.0, 10.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.RIVER.toString()), new BiomeTypeData(0.551f, 70.0, 40.0, 10.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.DEEP_LUKEWARM_OCEAN.toString()), new BiomeTypeData(0.596f, 70.0, 40.0, 10.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.EXTREME_HILLS.toString()), new BiomeTypeData(0.618f, 50.0, 40.0, 10.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.MOUNTAIN.toString()), new BiomeTypeData(0.618f, 50.0, 40.0, 10.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.LUKEWARM_OCEAN.toString()), new BiomeTypeData(0.64f, 70.0, 40.0, 10.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.BEACH.toString()), new BiomeTypeData(0.663f, 70.0, 40.0, 10.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.FOREST.toString()), new BiomeTypeData(0.663f, 50.0, 40.0, 12.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.UNDERGROUND.toString()), new BiomeTypeData(0.663f, 40.0, 40.0, 12.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.SWAMP.toString()), new BiomeTypeData(0.685f, 90.0, 40.0, 12.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.MUSHROOM.toString()), new BiomeTypeData(0.685f, 70.0, 40.0, 12.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.WARM_OCEAN.toString()), new BiomeTypeData(0.73f, 70.0, 40.0, 10.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.PLAINS.toString()), new BiomeTypeData(0.774f, 60.0, 40.0, 15.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.MISSING.toString()), new BiomeTypeData(0.774f, 40.0, 40.0, 15.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.LUSH_DESERT.toString()), new BiomeTypeData(0.886f, 60.0, 40.0, 15.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.DRYLAND.toString()), new BiomeTypeData(0.886f, 35.0, 40.0, 15.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.RAINFOREST.toString()), new BiomeTypeData(0.886f, 95.0, 40.0, 15.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.JUNGLE.toString()), new BiomeTypeData(0.997f, 90.0, 40.0, 15.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.VOLCANIC.toString()), new BiomeTypeData(1.04f, 35.0, 40.0, 15.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.DEAD_SEA.toString()), new BiomeTypeData(1.04f, 35.0, 40.0, 15.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.SAVANNA.toString()), new BiomeTypeData(1.108f, 30.0, 40.0, 15.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.MESA.toString()), new BiomeTypeData(1.309f, 20.0, 40.0, 15.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.DESERT.toString()), new BiomeTypeData(1.354f, 20.0, 40.0, 20.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.NONE.toString()), new BiomeTypeData(0.15f, 40.0, 40.0, 0.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.THEEND.toString()), new BiomeTypeData(0.551f, 40.0, 40.0, 0.0, false));
        this.add(Homeostatic.prefix(BiomeCategory.Type.NETHER.toString()), new BiomeTypeData(1.666f, 20.0, 40.0, 0.0, false));
    }

    protected void add(class_2960 loc, BiomeTypeData biomeTypeData) {
        this.BIOME_TYPES_MAP.put(loc, biomeTypeData);
    }

    @NotNull
    public String method_10321() {
        return "Homeostatic - Biome Type Data";
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 cache) throws IllegalStateException {
        ArrayList<CompletableFuture> recipeList = new ArrayList<CompletableFuture>();
        this.registerBiomeTypeData();
        for (Map.Entry<class_2960, BiomeTypeData> entry : this.BIOME_TYPES_MAP.entrySet()) {
            class_7784.class_7489 pathProvider = this.getPath(entry.getKey());
            recipeList.add(class_2405.method_10320((class_7403)cache, (JsonElement)BiomeTypeDataManager.parseBiomeData(entry.getValue()), (Path)pathProvider.method_44107(entry.getKey())));
        }
        return CompletableFuture.allOf((CompletableFuture[])recipeList.toArray(CompletableFuture[]::new));
    }

    private class_7784.class_7489 getPath(class_2960 loc) {
        return this.packOutput.method_45973(class_7784.class_7490.field_39367, "environment/biome_type_data/");
    }
}

