/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.biome;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.biome.BiomeCategory;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;

public class BiomeCategoryManager
extends class_4309<JsonElement> {
    private static final Map<class_2960, BiomeCategory> BIOME_CATEGORIES = new HashMap<class_2960, BiomeCategory>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BiomeCategory.class, (Object)new BiomeCategory.Serializer()).create();

    public BiomeCategoryManager() {
        super(class_5699.field_40721, class_7654.method_45114((String)"environment/biome_category"));
    }

    public static JsonElement parseBiomeCategory(BiomeCategory biomeCategory) {
        return GSON.toJsonTree((Object)biomeCategory);
    }

    public static BiomeCategory.Type getBiomeCategory(class_6880<class_1959> biome) {
        try {
            Optional key = biome.method_40230();
            BiomeCategory biomeCategory = key.isPresent() ? BIOME_CATEGORIES.getOrDefault(((class_5321)key.get()).method_29177(), BiomeCategory.MISSING) : BiomeCategory.MISSING;
            return BiomeCategory.Type.valueOf(biomeCategory.type());
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            Homeostatic.LOGGER.debug("Unable to find biome for: {}", (Object)biome.toString());
            return BiomeCategory.Type.MISSING;
        }
    }

    protected void apply(Map<class_2960, JsonElement> pObject, @NotNull class_3300 pResourceManager, @NotNull class_3695 pProfiler) {
        BIOME_CATEGORIES.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            try {
                BiomeCategory biomeCategory = (BiomeCategory)GSON.fromJson(entry.getValue(), BiomeCategory.class);
                BIOME_CATEGORIES.put(biomeCategory.loc(), biomeCategory);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse biome category {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded category for {} biomes.", (Object)BIOME_CATEGORIES.size());
    }
}

