/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.block;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.block.BlockRadiation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5699;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class BlockRadiationManager
extends class_4309<JsonElement> {
    private static final Map<class_2248, BlockRadiation> RADIATION_BLOCKS = new HashMap<class_2248, BlockRadiation>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockRadiation.class, (Object)new BlockRadiation.Serializer()).create();

    public BlockRadiationManager() {
        super(class_5699.field_40721, class_7654.method_45114((String)"environment/block_radiation"));
    }

    public static JsonElement parseBlockRadiation(BlockRadiation blockRadiation) {
        return GSON.toJsonTree((Object)blockRadiation);
    }

    public static BlockRadiation getBlockRadiation(class_2248 block) {
        return RADIATION_BLOCKS.get(block);
    }

    protected void apply(Map<class_2960, JsonElement> pObject, @NotNull class_3300 pResourceManager, @NotNull class_3695 pProfiler) {
        RADIATION_BLOCKS.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            try {
                BlockRadiation blockRadiation = (BlockRadiation)GSON.fromJson(entry.getValue(), BlockRadiation.class);
                Optional block = class_7923.field_41175.method_10223(blockRadiation.loc());
                block.ifPresent(blockReference -> RADIATION_BLOCKS.put((class_2248)blockReference.comp_349(), blockRadiation));
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse block radiation {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} radiation blocks", (Object)RADIATION_BLOCKS.size());
    }
}

