/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.fluid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.fluid.DrinkingFluid;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5699;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class DrinkingFluidManager
extends class_4309<JsonElement> {
    private static final Map<class_3611, DrinkingFluid> FLUIDS = new HashMap<class_3611, DrinkingFluid>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DrinkingFluid.class, (Object)new DrinkingFluid.Serializer()).create();

    public DrinkingFluidManager() {
        super(class_5699.field_40721, class_7654.method_45114((String)"environment/fluids"));
    }

    public static JsonElement parseDrinkingFluid(DrinkingFluid drinkingFluid) {
        return GSON.toJsonTree((Object)drinkingFluid);
    }

    public static DrinkingFluid get(class_3611 fluid) {
        return FLUIDS.get(fluid);
    }

    protected void apply(Map<class_2960, JsonElement> pObject, @NotNull class_3300 pResourceManager, @NotNull class_3695 pProfiler) {
        FLUIDS.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            try {
                DrinkingFluid drinkingFluid = (DrinkingFluid)GSON.fromJson(entry.getValue(), DrinkingFluid.class);
                Optional fluid = class_7923.field_41173.method_10223(drinkingFluid.loc());
                fluid.ifPresent(fluidReference -> FLUIDS.put((class_3611)fluidReference.comp_349(), drinkingFluid));
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse drinking fluid {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} drinking fluids", (Object)FLUIDS.size());
    }
}

