/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.item.IItemStackFluid;
import homeostatic.platform.Services;
import homeostatic.util.WaterHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5328;
import org.jetbrains.annotations.NotNull;

public class WaterContainerItem
extends class_1792
implements IItemStackFluid {
    protected final int capacity;
    protected final int uses;

    public WaterContainerItem(class_1792.class_1793 properties, int capacity, int uses) {
        super(properties.method_7895(capacity));
        this.capacity = capacity;
        this.uses = uses;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getUses() {
        return this.uses;
    }

    public int getSingleUse() {
        return this.capacity / this.uses;
    }

    @NotNull
    public class_1269 method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_3965 hitResult = WaterContainerItem.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1345);
        class_2338 pos = hitResult.method_17777();
        class_2680 blockState = level.method_8320(pos);
        class_3611 targetFluid = blockState.method_26227().method_15772();
        Optional<FluidInfo> fluidInfoOptional = Services.PLATFORM.getFluidInfo(stack);
        if (fluidInfoOptional.isEmpty()) {
            return class_1269.field_5814;
        }
        FluidInfo fluidInfo = fluidInfoOptional.get();
        boolean isEmpty = fluidInfo.isEmpty();
        if ((isEmpty || fluidInfo.fluid().method_15780(targetFluid)) && fluidInfo.amount() != (long)this.capacity) {
            class_2263 bucketPickup;
            class_2248 class_22482;
            if (targetFluid == class_3612.field_15910) {
                return class_1269.field_5812.method_61393(this.getFilledItem(stack, player, targetFluid, this.capacity));
            }
            if (WaterHelper.getFluidHydration(targetFluid) != null && (class_22482 = blockState.method_26204()) instanceof class_2263 && !(bucketPickup = (class_2263)class_22482).method_9700((class_1309)player, (class_1936)level, pos, blockState).method_7960()) {
                return class_1269.field_5812.method_61393(this.getFilledItem(stack, player, targetFluid, this.capacity));
            }
        }
        if (!isEmpty && this.canDrink(player, fluidInfo)) {
            return class_5328.method_29282((class_1937)level, (class_1657)player, (class_1268)hand);
        }
        return class_1269.field_5814;
    }

    @NotNull
    public class_1799 method_7861(class_1799 stack, @NotNull class_1937 level, @NotNull class_1309 entity) {
        if (entity instanceof class_3222) {
            class_3222 sp = (class_3222)entity;
            class_174.field_1198.method_8821(sp, stack);
        }
        return Services.PLATFORM.drainFluid(stack, this.getCapacity() / this.getUses());
    }

    public void method_67187(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull class_10712 tooltipDisplay, @NotNull Consumer<class_2561> components, @NotNull class_1836 flag) {
        class_5250 textComponent = class_2561.method_43471((String)"tooltip.water_container.empty").method_10862(class_2583.field_24360.method_27706(class_124.field_1080));
        Optional<FluidInfo> fluidInfoOptional = Services.PLATFORM.getFluidInfo(stack);
        if (fluidInfoOptional.isPresent() && fluidInfoOptional.get().amount() > 0L) {
            textComponent = Services.PLATFORM.getDisplayName(fluidInfoOptional.get().fluid());
            long amount = fluidInfoOptional.get().amount();
            components.accept((class_2561)class_2561.method_43471((String)(textComponent.getString() + String.format(": %d uses.", amount / (long)this.getSingleUse()))).method_10862(class_2583.field_24360.method_27706(class_124.field_1080)));
        } else {
            components.accept((class_2561)textComponent);
        }
    }

    public int method_7881(@NotNull class_1799 stack, @NotNull class_1309 entity) {
        return 32;
    }

    @NotNull
    public class_1839 method_7853(@NotNull class_1799 stack) {
        return class_1839.field_8946;
    }

    public class_1799 getFilledItem(class_1799 stack, class_1657 player, class_3611 fluid, int amount) {
        class_1799 copy = WaterHelper.getFilledItem(stack, fluid, amount);
        player.method_5783(class_3417.field_15126, 1.0f, 1.0f);
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        return copy;
    }

    public boolean canDrink(class_1657 player, FluidInfo fluidInfo) {
        AtomicBoolean canDrink = new AtomicBoolean(WaterHelper.getFluidHydration(fluidInfo.fluid()) != null && fluidInfo.amount() >= (long)this.getSingleUse());
        Services.PLATFORM.getWaterCapabilty(player).ifPresent(data -> canDrink.set(canDrink.get() && data.getWaterLevel() < 20));
        return canDrink.get();
    }
}

