/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data.book;

import guidebook.api.data.AbstractPageBuilder;
import guidebook.api.data.BookBuilder;
import guidebook.api.data.CategoryBuilder;
import guidebook.api.data.EntryBuilder;
import guidebook.api.data.GuidebookBookProvider;
import guidebook.api.data.page.CampfirePageBuilder;
import guidebook.api.data.page.CraftingPageBuilder;
import guidebook.api.data.page.ImagePageBuilder;
import guidebook.api.data.page.SmeltingPageBuilder;
import homeostatic.Homeostatic;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.data.book.CustomRecipePageBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

public class HomeostaticBookProvider
extends GuidebookBookProvider {
    private final String translationLoc = "info.homeostatic.book";
    private int categorySortNum = -1;
    private int entrySortNum = -1;

    public HomeostaticBookProvider(@NotNull class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookupProvider) {
        super(packOutput, "homeostatic", "en_us", lookupProvider);
    }

    protected void addBooks(Consumer<BookBuilder> consumer, class_7225.class_7874 provider) {
        BookBuilder bookBuilder = this.createBookBuilder("book", "item.homeostatic.book", this.prefix("intro"), provider).setSubtitle(this.prefix("subtitle")).setCustomBookItem(new class_1799((class_1935)HomeostaticItems.BOOK)).setCreativeTab("homeostatic.items").setModel("homeostatic:book").setDontGenerateBook(true).setShowProgress(false).setUseBlockyFont(false).setI18n(true);
        bookBuilder = this.addGameplay(bookBuilder);
        bookBuilder = this.addEducation(bookBuilder);
        bookBuilder.build(consumer);
    }

    private BookBuilder addGameplay(BookBuilder bookBuilder) {
        class_1799 sword = new class_1799((class_1935)class_1802.field_8371);
        class_1799 flask = new class_1799((class_1935)HomeostaticItems.LEATHER_FLASK);
        flask.method_7974(0);
        sword.method_7974(0);
        CategoryBuilder category = bookBuilder.addCategory("gameplay", this.prefix("gameplay.name"), this.prefix("gameplay.desc"), sword).setSortnum(Integer.valueOf(this.categorySortNum++));
        EntryBuilder gameplayEnvironmentEntry = category.addEntry("gameplay/environment", this.prefix("gameplay.environment.name"), new class_1799((class_1935)class_1802.field_17346)).setSortnum(this.entrySortNum++);
        gameplayEnvironmentEntry.addImagePage(this.bookImage("normal_outside")).setTitle(this.prefix("gameplay.environment.title")).setText(this.prefix("gameplay.environment.intro")).build().addTextPage(this.prefix("gameplay.environment.details")).build();
        EntryBuilder gameplayBodyTempEntry = category.addEntry("gameplay/body_temp", this.prefix("gameplay.body_temp.name"), new class_1799((class_1935)class_1802.field_19052)).setSortnum(this.entrySortNum++);
        ((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((ImagePageBuilder)((ImagePageBuilder)((ImagePageBuilder)((ImagePageBuilder)gameplayBodyTempEntry.addImagePage(this.bookImage("normal_body")).setTitle(this.prefix("gameplay.body_temp.title")).setText(this.prefix("gameplay.body_temp.intro")).build().addTextPage(this.prefix("gameplay.body_temp.details")).build().addImagePage(this.bookImage("wetness_hud")).setAnchor("wetness")).setTitle(this.prefix("gameplay.body_temp.wetness.title")).setText(this.prefix("gameplay.body_temp.wetness.intro")).build().addTextPage(this.prefix("gameplay.body_temp.wetness.details")).build().addImagePage(this.bookImage("scalding_hud")).setAnchor("scalding")).setTitle(this.prefix("gameplay.body_temp.scalding.title")).setText(this.prefix("gameplay.body_temp.scalding.intro")).build().addImagePage(this.bookImage("hyperthermia_hud")).setAnchor("hyperthermia")).setTitle(this.prefix("gameplay.body_temp.hyperthermia.title")).setText(this.prefix("gameplay.body_temp.hyperthermia.intro")).build().addImagePage(this.bookImage("hypothermia_hud")).setAnchor("hypothermia")).setTitle(this.prefix("gameplay.body_temp.hypothermia.title")).setText(this.prefix("gameplay.body_temp.hypothermia.intro")).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.prefix("insulation"), gameplayBodyTempEntry))).setAnchor("insulation")).setTitle(this.prefix("gameplay.body_temp.insulation.title"))).setText(this.prefix("gameplay.body_temp.insulation.text"))).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.prefix("remove_insulation"), gameplayBodyTempEntry))).setAnchor("remove_insulation")).setTitle(this.prefix("gameplay.body_temp.remove_insulation.title"))).setText(this.prefix("gameplay.body_temp.remove_insulation.text"))).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.prefix("radiation_protection"), gameplayBodyTempEntry))).setAnchor("radiation_protection")).setTitle(this.prefix("gameplay.body_temp.radiation_protection.title"))).setText(this.prefix("gameplay.body_temp.radiation_protection.text"))).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.prefix("remove_radiation_protection"), gameplayBodyTempEntry))).setAnchor("remove_radiation_protection")).setTitle(this.prefix("gameplay.body_temp.remove_radiation_protection.title"))).setText(this.prefix("gameplay.body_temp.remove_radiation_protection.text"))).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.prefix("waterproof"), gameplayBodyTempEntry))).setAnchor("waterproofing")).setTitle(this.prefix("gameplay.body_temp.waterproof.title"))).setText(this.prefix("gameplay.body_temp.waterproof.text"))).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.prefix("remove_waterproof"), gameplayBodyTempEntry))).setAnchor("remove_waterproofing")).setTitle(this.prefix("gameplay.body_temp.remove_waterproof.title"))).setText(this.prefix("gameplay.body_temp.remove_waterproof.text"))).build();
        EntryBuilder gameplayHydrationEntry = category.addEntry("gameplay/hydration", this.prefix("gameplay.hydration.name"), flask).setSortnum(this.entrySortNum++);
        ((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((SmeltingPageBuilder)((SmeltingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CampfirePageBuilder)((CampfirePageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)gameplayHydrationEntry.addImagePage(this.bookImage("water_bar")).setTitle(this.prefix("gameplay.hydration.title")).setText(this.prefix("gameplay.hydration.intro")).build().addTextPage(this.prefix("gameplay.hydration.details")).build().addCraftingPage(class_2960.method_60655((String)"minecraft", (String)"glass_bottle")).setTitle(this.prefix("gameplay.hydration.water_bottle.title"))).setText(this.prefix("gameplay.hydration.water_bottle.text"))).build().addCampfirePage(Homeostatic.prefix("campfire_purified_water_bottle")).setTitle(this.prefix("gameplay.hydration.water_bottle.campfire.title"))).setText(this.prefix("gameplay.hydration.water_bottle.campfire.text"))).build().addCraftingPage(Homeostatic.prefix("leather_flask")).setTitle(this.prefix("gameplay.hydration.leather_flask.title"))).setText(this.prefix("gameplay.hydration.leather_flask.text"))).build().addSmeltingPage(Homeostatic.prefix("furnace_purified_leather_flask")).setTitle(this.prefix("gameplay.hydration.leather_flask.smelting.title"))).setText(this.prefix("gameplay.hydration.leather_flask.smelting.text"))).build().addCraftingPage(Homeostatic.prefix("water_filter")).setTitle(this.prefix("gameplay.hydration.water_filter.title"))).setText(this.prefix("gameplay.hydration.water_filter.text"))).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.prefix("filtered_water_flask"), gameplayHydrationEntry))).setTitle(this.prefix("gameplay.hydration.leather_flask_water_filter.title"))).setText(this.prefix("gameplay.hydration.leather_flask_water_filter.text"))).build();
        return category.build();
    }

    private BookBuilder addEducation(BookBuilder bookBuilder) {
        return bookBuilder.addCategory("education", this.prefix("education.name"), this.prefix("education.desc"), new class_1799((class_1935)class_1802.field_8536)).setSortnum(Integer.valueOf(this.categorySortNum++)).addEntry("education/environment", this.prefix("education.environment.name"), new class_1799((class_1935)class_1802.field_23842)).setSortnum(this.entrySortNum++).addTextPage(this.prefix("education.environment.intro")).build().build().addEntry("education/body_temp", this.prefix("education.body_temp.name"), new class_1799((class_1935)class_1802.field_19057)).setSortnum(this.entrySortNum++).addTextPage(this.prefix("education.body_temp.intro")).build().build().addEntry("education/hydration", this.prefix("education.hydration.name"), new class_1799((class_1935)HomeostaticItems.PURIFIED_WATER_BUCKET)).setSortnum(this.entrySortNum++).addTextPage(this.prefix("education.hydration.intro")).build().build().build();
    }

    private String prefix(String name) {
        return "info.homeostatic.book." + name;
    }

    private class_2960 bookImage(String id) {
        return class_2960.method_60655((String)"homeostatic", (String)("textures/gui/book/" + id + ".png"));
    }
}

