/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.damagesource.HomeostaticDamageTypes;
import homeostatic.common.water.WaterInfo;
import homeostatic.network.IWater;
import homeostatic.util.DamageHelper;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class Water
implements IWater {
    private int waterLevel = 20;
    private float waterSaturationLevel = 5.0f;
    private float waterExhaustionLevel = 0.0f;

    @Override
    public void setWaterLevel(int waterLevel) {
        this.waterLevel = waterLevel;
    }

    @Override
    public void increaseWaterLevel(int level) {
        this.waterLevel = Math.min(this.waterLevel + level, 20);
    }

    @Override
    public void increaseSaturationLevel(float level) {
        this.waterSaturationLevel = Math.min(this.waterSaturationLevel + level, 5.0f);
    }

    @Override
    public void setWaterSaturationLevel(float waterSaturationLevel) {
        this.waterSaturationLevel = waterSaturationLevel;
    }

    @Override
    public void setWaterExhaustionLevel(float waterExhaustionLevel) {
        this.waterExhaustionLevel = waterExhaustionLevel;
    }

    @Override
    public void setWaterData(WaterInfo waterInfo) {
        this.setWaterLevel(waterInfo.getWaterLevel());
        this.setWaterSaturationLevel(waterInfo.getWaterSaturationLevel());
        this.setWaterExhaustionLevel(waterInfo.getWaterExhaustionLevel());
    }

    @Override
    public int getWaterLevel() {
        return this.waterLevel;
    }

    @Override
    public float getWaterExhaustionLevel() {
        return this.waterExhaustionLevel;
    }

    @Override
    public float getWaterSaturationLevel() {
        return this.waterSaturationLevel;
    }

    @Override
    public void checkWaterLevel(class_3222 player) {
        if (this.waterLevel <= 0) {
            player.method_64397(player.method_51469(), new class_1282(DamageHelper.getHolder(player.method_51469().method_8503(), HomeostaticDamageTypes.DEHYDRATION)), 1.0f);
        }
    }

    @Override
    public class_2487 write(class_2487 tag) {
        tag.method_10569("waterLevel", this.getWaterLevel());
        tag.method_10548("waterExhaustion", this.getWaterExhaustionLevel());
        tag.method_10548("waterSaturation", this.getWaterSaturationLevel());
        return tag;
    }

    @Override
    public class_11372 write(class_11372 valueOutput) {
        valueOutput.method_71465("waterLevel", this.getWaterLevel());
        valueOutput.method_71464("waterExhaustion", this.getWaterExhaustionLevel());
        valueOutput.method_71464("waterSaturation", this.getWaterSaturationLevel());
        return valueOutput;
    }

    @Override
    public void read(class_2487 tag) {
        this.setWaterLevel((Integer)tag.method_10550("waterLevel").orElseThrow());
        this.setWaterExhaustionLevel(((Float)tag.method_10583("waterExhaustion").orElseThrow()).floatValue());
        this.setWaterSaturationLevel(((Float)tag.method_10583("waterSaturation").orElseThrow()).floatValue());
    }

    @Override
    public void read(class_11368 valueInput) {
        this.setWaterLevel(valueInput.method_71424("waterLevel", 0));
        this.setWaterExhaustionLevel(valueInput.method_71423("waterExhaustion", 0.0f));
        this.setWaterSaturationLevel(valueInput.method_71423("waterSaturation", 0.0f));
    }
}

