/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import homeostatic.Homeostatic;
import homeostatic.common.temperature.TemperatureRange;
import homeostatic.config.ConfigHandler;
import homeostatic.network.ITemperature;
import homeostatic.overlay.Overlay;
import homeostatic.platform.Services;
import homeostatic.util.Alignment;
import homeostatic.util.ColorHelper;
import homeostatic.util.FontHelper;
import homeostatic.util.TempHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class TemperatureGlobeOverlay
extends Overlay {
    public static final class_2960 SPRITE = Homeostatic.prefix("textures/gui/icons.png");
    protected static final int ICON_WIDTH = 18;
    protected static final int ICON_HEIGHT = 14;

    TemperatureGlobeOverlay() {
    }

    @Override
    public void render(class_332 guiGraphics, class_310 mc, @Nullable class_2338 pos, int scaledWidth, int scaledHeight) {
        class_746 player = mc.field_1724;
        Matrix3x2fStack matrix = guiGraphics.method_51448();
        if (player == null) {
            return;
        }
        Services.PLATFORM.getTemperatureData((class_1657)player).ifPresent(arg_0 -> this.lambda$render$1(scaledWidth, scaledHeight, mc, guiGraphics, (class_1657)player, matrix, arg_0));
    }

    private int getTempOffset(class_3545<TemperatureRange, Integer> rangeStep) {
        TemperatureRange range = (TemperatureRange)((Object)rangeStep.method_15442());
        int step = (Integer)rangeStep.method_15441() / 2;
        int offset = range == TemperatureRange.COLD ? 120 + step * 15 : 120 - step * 15;
        return offset;
    }

    private /* synthetic */ void lambda$render$1(int scaledWidth, int scaledHeight, class_310 mc, class_332 guiGraphics, class_1657 player, Matrix3x2fStack matrix, ITemperature data) {
        int offsetX = Alignment.getX(ConfigHandler.Client.globePosition(), scaledWidth, 18, ConfigHandler.Client.globeOffsetX());
        int pY = Alignment.getY(ConfigHandler.Client.globePosition(), scaledHeight, ConfigHandler.Client.globeOffsetY());
        float textScale = 0.5f;
        int textOffsetY = Alignment.getIconTextY(ConfigHandler.Client.globePosition(), scaledHeight, ConfigHandler.Client.globeTextOffsetY(), textScale);
        int pUOffset = 80;
        String coreTempFormat = ConfigHandler.Client.showDegreeSymbol() ? "%.1f\u00b0" : "%.1f";
        String localTempFormat = ConfigHandler.Client.showDegreeSymbol() ? "%.0f\u00b0" : "%.0f";
        String coreTempSmall = String.format(coreTempFormat, TempHelper.convertMcTemp(data.getCoreTemperature(), ConfigHandler.Client.useFahrenheit()));
        String localTemp = String.format(localTempFormat, TempHelper.convertMcTemp(data.getLocalTemperature(), ConfigHandler.Client.useFahrenheit()));
        AtomicBoolean showTemperature = new AtomicBoolean(ConfigHandler.Common.showTemperatureValues());
        int coreOffsetX = Alignment.getIconTextX(ConfigHandler.Client.globePosition(), scaledWidth, mc.field_1772.method_1727(coreTempSmall), ConfigHandler.Client.globeOffsetX(), textScale, 18);
        int localOffsetX = Alignment.getIconTextX(ConfigHandler.Client.globePosition(), scaledWidth, mc.field_1772.method_1727(localTemp), ConfigHandler.Client.globeOffsetX(), textScale, 18);
        class_3545<TemperatureRange, Integer> localRangeStep = TempHelper.getLocalTemperatureRangeStep(data.getLocalTemperature());
        class_3545<TemperatureRange, Integer> coreRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getCoreTemperature());
        int pV = this.getTempOffset(coreRangeStep);
        int localPV = this.getTempOffset(localRangeStep);
        guiGraphics.method_25290(class_10799.field_56883, SPRITE, offsetX, pY, (float)pUOffset, (float)pV, 18, 14, 256, 256);
        guiGraphics.method_25290(class_10799.field_56883, SPRITE, offsetX, pY, (float)(pUOffset + 18), (float)localPV, 18, 14, 256, 256);
        if (ConfigHandler.Common.requireThermometer()) {
            Services.PLATFORM.getThermometerCapability(player).ifPresent(thermometer -> showTemperature.set(thermometer.hasThermometer()));
        }
        if (showTemperature.get()) {
            matrix.scale(textScale, textScale);
            FontHelper.draw(mc, guiGraphics, localTemp, localOffsetX - 1, textOffsetY - 19, ColorHelper.getLocalTemperatureColor(localRangeStep), true);
            FontHelper.draw(mc, guiGraphics, coreTempSmall, coreOffsetX - 1, textOffsetY, ColorHelper.getGlobeTemperatureColor(coreRangeStep), true);
        }
    }
}

