/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.fluid;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import homeostatic.common.Hydration;
import java.lang.reflect.Type;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import technology.roughness.whitenoise.util.ResourceLocationHelper;

public record DrinkingFluid(class_2960 loc, int amount, float saturation, int potency, int duration, float chance) {
    public static final Codec<DrinkingFluid> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("fluid").forGetter(DrinkingFluid::loc), (App)Codec.INT.fieldOf("amount").forGetter(DrinkingFluid::amount), (App)Codec.FLOAT.fieldOf("saturation").forGetter(DrinkingFluid::saturation), (App)Codec.INT.fieldOf("effect_potency").forGetter(DrinkingFluid::potency), (App)Codec.INT.fieldOf("effect_duration").forGetter(DrinkingFluid::duration), (App)Codec.FLOAT.fieldOf("effect_chance").forGetter(DrinkingFluid::chance)).apply((Applicative)instance, DrinkingFluid::new));

    public static Hydration getHydration(DrinkingFluid fluid) {
        return new Hydration(fluid.amount(), fluid.saturation(), fluid.potency(), fluid.duration(), fluid.chance());
    }

    public static class Serializer
    implements JsonDeserializer<DrinkingFluid>,
    JsonSerializer<DrinkingFluid> {
        public DrinkingFluid deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"data");
            return new DrinkingFluid(ResourceLocationHelper.parse((String)json.get("fluid").getAsString()), json.get("amount").getAsInt(), json.get("saturation").getAsFloat(), json.get("effect_potency").getAsInt(), json.get("effect_duration").getAsInt(), json.get("effect_chance").getAsFloat());
        }

        public JsonElement serialize(DrinkingFluid drinkingFluid, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("fluid", drinkingFluid.loc().toString());
            json.addProperty("amount", (Number)drinkingFluid.amount());
            json.addProperty("saturation", (Number)Float.valueOf(drinkingFluid.saturation()));
            json.addProperty("effect_potency", (Number)drinkingFluid.potency());
            json.addProperty("effect_duration", (Number)drinkingFluid.duration());
            json.addProperty("effect_chance", (Number)Float.valueOf(drinkingFluid.chance()));
            return json;
        }
    }
}

