/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.fluid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import homeostatic.Homeostatic;
import homeostatic.common.fluid.DrinkingFluid;
import homeostatic.network.SyncDrinkingFluids;
import homeostatic.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5699;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class DrinkingFluidManager
extends class_4309<JsonElement> {
    private static final Map<class_3611, DrinkingFluid> FLUIDS = new HashMap<class_3611, DrinkingFluid>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DrinkingFluid.class, (Object)new DrinkingFluid.Serializer()).create();

    public DrinkingFluidManager() {
        super(class_5699.field_40721, class_7654.method_45114((String)"environment/fluids"));
    }

    public static JsonElement parseDrinkingFluid(DrinkingFluid drinkingFluid) {
        return GSON.toJsonTree((Object)drinkingFluid);
    }

    public static DrinkingFluid get(class_3611 fluid) {
        return FLUIDS.get(fluid);
    }

    public static void update(List<DrinkingFluid> drinkingFluids) {
        FLUIDS.clear();
        for (DrinkingFluid drinkingFluid : drinkingFluids) {
            Optional fluid = class_7923.field_41173.method_10223(drinkingFluid.loc());
            fluid.ifPresent(reference -> FLUIDS.put((class_3611)reference.comp_349(), drinkingFluid));
        }
        Homeostatic.LOGGER.info("Updated {} drinking fluids", (Object)FLUIDS.size());
    }

    protected void apply(Map<class_2960, JsonElement> pObject, @NotNull class_3300 pResourceManager, @NotNull class_3695 pProfiler) {
        FLUIDS.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            try {
                DrinkingFluid drinkingFluid = (DrinkingFluid)GSON.fromJson(entry.getValue(), DrinkingFluid.class);
                Optional fluid = class_7923.field_41173.method_10223(drinkingFluid.loc());
                fluid.ifPresent(fluidReference -> FLUIDS.put((class_3611)fluidReference.comp_349(), drinkingFluid));
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse drinking fluid {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} drinking fluids", (Object)FLUIDS.size());
    }

    public static void syncWithClient(class_3222 player) {
        if (player != null) {
            List<DrinkingFluid> drinkingFluids = FLUIDS.values().stream().toList();
            DataResult result = Codec.list(DrinkingFluid.CODEC).encodeStart((DynamicOps)class_2509.field_11560, drinkingFluids);
            class_2520 data = (class_2520)result.getOrThrow(fluids -> {
                throw new IllegalStateException("Failed to encode drinking fluids: " + fluids);
            });
            Services.PLATFORM.sendPacketToPlayer(new SyncDrinkingFluids(data), player);
        }
    }
}

