/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import homeostatic.Homeostatic;
import homeostatic.common.TagManager;
import homeostatic.common.item.DrinkableItem;
import homeostatic.network.SyncDrinkableItems;
import homeostatic.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5699;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class DrinkableItemManager
extends class_4309<JsonElement> {
    private static final Map<class_1792, DrinkableItem> ITEMS = new HashMap<class_1792, DrinkableItem>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DrinkableItem.class, (Object)new DrinkableItem.Serializer()).create();
    private static final DrinkableItem FRUIT = new DrinkableItem(TagManager.Items.FRUITS.comp_327(), 2, 0.6f, 0, 0, 0.0f);
    private static final DrinkableItem ROOT_VEGETABLE = new DrinkableItem(TagManager.Items.ROOT_VEGETABLES.comp_327(), 1, 0.1f, 0, 0, 0.0f);
    private static final DrinkableItem VEGETABLE = new DrinkableItem(TagManager.Items.VEGETABLES.comp_327(), 1, 0.1f, 0, 0, 0.0f);

    public DrinkableItemManager() {
        super(class_5699.field_40721, class_7654.method_45114((String)"environment/drinkable"));
    }

    public static JsonElement parseDrinkableItem(DrinkableItem drinkableItem) {
        return GSON.toJsonTree((Object)drinkableItem);
    }

    public static DrinkableItem get(class_1799 stack) {
        DrinkableItem drinkableItem = ITEMS.get(stack.method_7909());
        if (drinkableItem != null) {
            return drinkableItem;
        }
        if (stack.method_31573(TagManager.Items.FRUITS)) {
            return FRUIT;
        }
        if (stack.method_31573(TagManager.Items.ROOT_VEGETABLES)) {
            return ROOT_VEGETABLE;
        }
        if (stack.method_31573(TagManager.Items.VEGETABLES)) {
            return VEGETABLE;
        }
        return null;
    }

    public static void update(List<DrinkableItem> drinkableItems) {
        ITEMS.clear();
        for (DrinkableItem drinkableItem : drinkableItems) {
            Optional optionalItemReference = class_7923.field_41178.method_10223(drinkableItem.loc());
            optionalItemReference.ifPresent(itemReference -> ITEMS.put((class_1792)itemReference.comp_349(), drinkableItem));
        }
        Homeostatic.LOGGER.info("Updated {} drinkable items", (Object)ITEMS.size());
    }

    protected void apply(Map<class_2960, JsonElement> pObject, @NotNull class_3300 pResourceManager, @NotNull class_3695 pProfiler) {
        ITEMS.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            try {
                DrinkableItem drinkableItem = (DrinkableItem)GSON.fromJson(entry.getValue(), DrinkableItem.class);
                Optional item = class_7923.field_41178.method_10223(drinkableItem.loc());
                item.ifPresent(itemReference -> ITEMS.put((class_1792)itemReference.comp_349(), drinkableItem));
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse drinkable item {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} drinkable items", (Object)ITEMS.size());
    }

    public static void syncWithClient(class_3222 player) {
        if (player != null) {
            List<DrinkableItem> drinkableItems = ITEMS.values().stream().toList();
            DataResult result = Codec.list(DrinkableItem.CODEC).encodeStart((DynamicOps)class_2509.field_11560, drinkableItems);
            class_2520 data = (class_2520)result.getOrThrow(items -> {
                throw new IllegalStateException("Failed to encode drinkable items: " + items);
            });
            Services.PLATFORM.sendPacketToPlayer(new SyncDrinkableItems(data), player);
        }
    }
}

