/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.temperature;

import homeostatic.Homeostatic;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.temperature.Environment;
import homeostatic.common.temperature.EnvironmentData;
import homeostatic.common.temperature.TemperatureDirection;
import homeostatic.common.temperature.TemperatureThreshold;
import homeostatic.config.ConfigHandler;
import homeostatic.network.ITemperature;
import homeostatic.util.InsulationHelper;
import homeostatic.util.TempHelper;
import homeostatic.util.WaterHelper;
import homeostatic.util.WetnessHelper;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class BodyTemperature {
    private final EnvironmentData environmentData;
    private final TemperatureDirection skinTemperatureDirection;
    private final int wetness;
    private float coreTemperature;
    private float skinTemperature;
    private float lastSkinTemperature;
    private float LOW;
    private float NORMAL;
    private float HIGH;

    public BodyTemperature(class_3222 sp, EnvironmentData environmentData, ITemperature tempData) {
        this(sp, environmentData, tempData, false, false);
    }

    public BodyTemperature(class_3222 sp, EnvironmentData environmentData, ITemperature tempData, boolean updateCore, boolean updateSkin) {
        this.LOW = TemperatureThreshold.LOW.temperature;
        this.NORMAL = TemperatureThreshold.NORMAL.temperature;
        this.HIGH = TemperatureThreshold.HIGH.temperature;
        this.environmentData = environmentData;
        this.wetness = WetnessHelper.getWetness(sp);
        this.setCoreTemperature(tempData.getCoreTemperature());
        this.skinTemperatureDirection = TempHelper.getSkinTemperatureDirection(environmentData.getLocalTemperature(), tempData.getSkinTemperature());
        this.setSkinTemperature(sp, tempData.getSkinTemperature(), updateSkin);
        if (updateCore) {
            this.updateCoreTemperature(sp);
        }
    }

    public float getCoreTemperature() {
        return this.coreTemperature;
    }

    public float getSkinTemperature() {
        return this.skinTemperature;
    }

    public float getLastSkinTemperature() {
        return this.lastSkinTemperature;
    }

    public void updateCoreTemperature(class_3222 sp) {
        TemperatureDirection coreTemperatureDirection = TempHelper.getCoreTemperatureDirection(this.lastSkinTemperature, this.coreTemperature, this.skinTemperature);
        float diff = Math.abs(this.skinTemperature - this.coreTemperature);
        float change = coreTemperatureDirection.coreRate > 0.0f ? diff * coreTemperatureDirection.coreRate : diff * 0.1f;
        if (this.skinTemperature < this.coreTemperature) {
            boolean hasFrostResistance = sp.method_6059(class_7923.field_41174.method_47983((Object)HomeostaticEffects.FROST_RESISTANCE));
            if (!hasFrostResistance) {
                this.coreTemperature -= change;
                if (coreTemperatureDirection == TemperatureDirection.COOLING_RAPIDLY) {
                    this.coreTemperature = Math.max(this.coreTemperature, this.NORMAL);
                }
            }
        } else {
            this.coreTemperature += change;
            if (coreTemperatureDirection == TemperatureDirection.WARMING_RAPIDLY) {
                this.coreTemperature = Math.min(this.coreTemperature, this.NORMAL);
            }
        }
    }

    private void setCoreTemperature(float coreTemperature) {
        this.coreTemperature = coreTemperature;
    }

    private void setSkinTemperature(class_3222 sp, float skinTemperature, boolean updateSkin) {
        float localTemperature = this.environmentData.getLocalTemperature();
        boolean canSweat = skinTemperature >= this.NORMAL && this.wetness == 0;
        boolean inWater = this.environmentData.isSubmerged() || this.environmentData.isPartialSubmersion();
        this.lastSkinTemperature = skinTemperature;
        this.skinTemperature = skinTemperature;
        if (!updateSkin) {
            return;
        }
        double insulationModifier = InsulationHelper.getInsulationModifier(sp, this.wetness, this.skinTemperatureDirection, localTemperature);
        float tempChange = inWater ? this.getWaterTemperatureSkinChange(insulationModifier) : this.getAirTemperatureSkinChange(sp, insulationModifier);
        if (tempChange > 0.0f) {
            switch (this.skinTemperatureDirection) {
                case COOLING: {
                    tempChange = Math.max(-tempChange * 70.0f, -0.06686747f);
                    if (this.wetness <= 0) break;
                    tempChange *= (float)(1.0 + (double)this.wetness / 20.0);
                    break;
                }
                case COOLING_RAPIDLY: {
                    tempChange = Math.max(-tempChange * 100.0f, -0.08915663f);
                    if (this.wetness <= 0) break;
                    tempChange *= (float)(2.0 + (double)this.wetness / 20.0);
                    break;
                }
                case COOLING_NORMALLY: {
                    tempChange = -tempChange;
                    if (canSweat) break;
                    float exhaustion = Math.abs(Math.min(tempChange * 200.0f, 0.1f));
                    int foodLevel = sp.method_7344().method_7586();
                    if (foodLevel <= 6 || !(Homeostatic.RANDOM.nextFloat() < 0.2f)) break;
                    sp.method_7344().method_7583(exhaustion);
                    break;
                }
                case WARMING: {
                    if (canSweat) {
                        WaterHelper.updateWaterInfo(sp, Math.min(tempChange * 150.0f, 0.3f));
                        break;
                    }
                    tempChange = Math.min(tempChange * 70.0f, 0.06686747f);
                    break;
                }
                case WARMING_RAPIDLY: {
                    tempChange = Math.min(tempChange * 100.0f, 0.08915663f);
                    break;
                }
                case WARMING_NORMALLY: {
                    if (!canSweat) break;
                    WaterHelper.updateWaterInfo(sp, Math.min(tempChange * 100.0f, 0.1f));
                }
            }
        }
        if (localTemperature < Environment.PARITY_HIGH && !canSweat && Homeostatic.RANDOM.nextFloat() < 0.17f) {
            WaterHelper.updateWaterInfo(sp, ConfigHandler.Common.getRandomWaterLoss());
        }
        if (sp.field_27857 && this.skinTemperature >= this.NORMAL) {
            tempChange = -((this.skinTemperature - this.NORMAL) / 10.0f);
        }
        if (tempChange == 0.0f) {
            if (this.skinTemperature < this.NORMAL) {
                tempChange = (this.NORMAL - this.skinTemperature) / 20.0f;
            } else if (this.skinTemperature > this.NORMAL) {
                tempChange = -((this.skinTemperature - this.NORMAL) / 40.0f);
            }
        }
        this.skinTemperature += tempChange;
        if (this.skinTemperature > this.NORMAL && this.skinTemperature > this.lastSkinTemperature && localTemperature < this.skinTemperature) {
            float coolingRate = Math.max((this.skinTemperature - this.NORMAL) / 20.0f, 0.022289157f);
            if (canSweat) {
                WaterHelper.updateWaterInfo(sp, Math.min(tempChange * 150.0f, 0.2f));
                this.skinTemperature = Math.max(this.skinTemperature - coolingRate, this.NORMAL);
            } else {
                this.skinTemperature = Math.max(this.skinTemperature - coolingRate * 2.0f, this.NORMAL);
            }
        }
    }

    public float getWaterTemperatureSkinChange(double insulationModifier) {
        float change = 0.0f;
        float localTemperature = this.environmentData.getLocalTemperature();
        double localTempF = TempHelper.convertMcTemp(localTemperature, true);
        double parityTempF = TempHelper.convertMcTemp(Environment.PARITY, true);
        if (this.skinTemperatureDirection == TemperatureDirection.NONE) {
            return change;
        }
        if (localTemperature < Environment.PARITY) {
            double temp = Math.max(Math.min(localTempF + insulationModifier, parityTempF), 0.0);
            double minutes = 8.845477E-7 * Math.pow(temp, 4.75641);
            change = (this.NORMAL - this.LOW) / (float)minutes;
        } else {
            double temp = Math.max(localTempF - insulationModifier, parityTempF);
            double minutes = 2.981948 + 601.889152 / (1.0 + Math.pow(temp / 109.9434, 50.72627));
            change = (this.HIGH - this.NORMAL) / (float)minutes;
        }
        if (change != 0.0f && this.environmentData.isPartialSubmersion()) {
            change /= 2.0f;
        }
        return change;
    }

    public float getAirTemperatureSkinChange(class_3222 sp, double insulationModifier) {
        float localTemperature = this.environmentData.getLocalTemperature();
        float change = 0.0f;
        double localTempF = TempHelper.convertMcTemp(localTemperature, true);
        double parityTempF = TempHelper.convertMcTemp(Environment.PARITY, true);
        double extremeTempF = TempHelper.convertMcTemp(Environment.EXTREME_HEAT, true);
        float radiationModifier = (float)(this.environmentData.getEnvRadiation() / 5000.0) + 1.0f;
        float moisture = 0.0f;
        if (!sp.method_5721()) {
            moisture = 0.2f * (3.0f + radiationModifier);
        }
        if (moisture > 0.0f) {
            WetnessHelper.updateWetnessInfo(sp, moisture, false);
        }
        if (this.skinTemperatureDirection == TemperatureDirection.NONE) {
            return change;
        }
        if (localTemperature < Environment.PARITY) {
            double temp = Math.max(Math.min(localTempF + insulationModifier, parityTempF), 0.0);
            if (Math.abs(parityTempF - temp) > 5.0) {
                double minutes = 383.4897 + -371.10186000000004 / (1.0 + Math.pow(temp / 43.26779, 8.271186));
                change = (this.NORMAL - this.LOW) / (float)minutes;
            }
        } else {
            double temp = Math.max(localTempF - insulationModifier, parityTempF);
            if (Math.abs(parityTempF - temp) > 5.0) {
                if (temp > extremeTempF) {
                    change = (float)((temp - extremeTempF) / 50.0) * 0.0067f;
                } else {
                    double minutes = 24.45765 + 574.8975499999999 / (1.0 + Math.pow(temp / 109.1499, 27.47623));
                    change = (this.HIGH - this.NORMAL) / (float)minutes;
                }
            }
        }
        if (this.coreTemperature < this.NORMAL && this.environmentData.getEnvRadiation() > 0.0 || radiationModifier > 5.0f) {
            change *= radiationModifier;
        }
        return change;
    }
}

