/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.temperature;

import climatesettings.common.biome.BiomeTypeData;
import climatesettings.common.biome.BiomeTypeDataManager;
import climatesettings.common.biome.HomeostaticClimateSettings;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import homeostatic.common.temperature.Environment;
import homeostatic.common.temperature.EnvironmentInfo;
import homeostatic.common.temperature.SubSeason;
import homeostatic.util.RegistryHelper;
import homeostatic.util.TempHelper;
import homeostatic.util.WetnessHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3543;
import net.minecraft.class_5217;
import net.minecraft.class_5268;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7924;
import technology.roughness.whitenoise.platform.Services;

public class EnvironmentData {
    private boolean isSubmerged;
    private boolean isPartialSubmersion;
    private double relativeHumidity;
    private float airTemperature;
    private float waterTemperature;
    private float localTemperature;
    private double envRadiation;
    private static final class_3543 TEMPERATURE_NOISE = new class_3543((class_5819)new class_2919((class_5819)new class_5820(1234L)), (List)ImmutableList.of((Object)0));

    public EnvironmentData(class_3222 sp, class_2338 pos, class_6880<class_1959> biome, class_3218 level) {
        ArrayList<Pair> biomes = new ArrayList<Pair>();
        int chunkRange = 3;
        float accumulatedDryTemp = 0.0f;
        float accumulatedHumidity = 0.0f;
        float moisture = 0.0f;
        EnvironmentInfo envData = Environment.get(level, sp);
        boolean isUnderground = envData.isUnderground();
        boolean isSheltered = envData.isSheltered();
        double waterVolume = envData.getWaterVolume();
        class_2378 biomeRegistry = RegistryHelper.getRegistry(level.method_8503(), class_7924.field_41236);
        class_6880 lushBiome = biomeRegistry.method_47983((Object)((class_1959)biomeRegistry.method_31140(class_1972.field_29218)));
        this.envRadiation = envData.getRadiation();
        this.isPartialSubmersion = !sp.method_5869() && sp.method_5799() && sp.method_5721();
        boolean bl = this.isSubmerged = sp.method_5869() && sp.method_5799() && sp.method_5721();
        if (this.isSubmerged) {
            moisture = 20.0f;
        } else if (this.isPartialSubmersion) {
            moisture = 10.0f;
        } else if (sp.method_5721()) {
            moisture = 0.5f;
        }
        if (moisture > 0.0f) {
            WetnessHelper.updateWetnessInfo(sp, moisture, true);
        }
        if (!this.isPartialSubmersion && !sp.method_5765()) {
            this.isPartialSubmersion = sp.method_55667().method_27852(class_2246.field_10382);
        }
        if (isSheltered || isUnderground) {
            biomes.add(Pair.of((Object)lushBiome, (Object)pos));
        }
        if (!isUnderground || this.isSubmerged) {
            for (int x = -chunkRange; x <= chunkRange; ++x) {
                for (int z = -chunkRange; z <= chunkRange; ++z) {
                    class_2338 chunkPos = pos.method_10069(x * 16, 0, z * 16);
                    if (!level.method_8477(chunkPos)) continue;
                    biomes.add(Pair.of((Object)level.method_23753(chunkPos), (Object)chunkPos));
                }
            }
        }
        for (Pair pair : biomes) {
            class_6880 chunkBiome = (class_6880)pair.getFirst();
            class_2338 chunkPos = (class_2338)pair.getSecond();
            float chunkTemp = EnvironmentData.getHeightAdjustedTemperature(level, (class_6880<class_1959>)chunkBiome, chunkPos);
            accumulatedDryTemp += isUnderground ? chunkTemp : EnvironmentData.getSeasonAdjustedTemperature(level, (class_6880<class_1959>)chunkBiome, chunkTemp, chunkPos);
            if (!level.method_64395().method_8355(class_1928.field_19406)) continue;
            double chunkHumidity = EnvironmentData.getBiomeHumidity(level, (class_6880<class_1959>)chunkBiome, chunkPos);
            accumulatedHumidity = (float)((double)accumulatedHumidity + chunkHumidity);
        }
        this.relativeHumidity = accumulatedHumidity / (float)biomes.size();
        float dayNightOffset = isUnderground ? 0.0f : EnvironmentData.getDayNightOffset(level, biome, this.relativeHumidity);
        float dryTemp = accumulatedDryTemp / (float)biomes.size() + dayNightOffset;
        float wetTemp = (float)TempHelper.getHeatIndex(dryTemp, this.relativeHumidity);
        float blackGlobeTemp = (float)this.getBlackGlobeTemp(level, pos, dryTemp, this.relativeHumidity);
        this.airTemperature = isSheltered || isUnderground ? wetTemp * 0.7f + blackGlobeTemp * 0.3f : wetTemp * 0.7f + blackGlobeTemp * 0.2f + dryTemp * 0.1f;
        if (this.isSubmerged || this.isPartialSubmersion) {
            this.waterTemperature = EnvironmentData.getWaterTemperature(this.airTemperature, waterVolume);
            this.localTemperature = this.isSubmerged ? this.waterTemperature : this.waterTemperature * 0.7f + this.airTemperature * 0.3f;
        } else {
            this.localTemperature = this.airTemperature;
        }
    }

    public boolean isSubmerged() {
        return this.isSubmerged;
    }

    public boolean isPartialSubmersion() {
        return this.isPartialSubmersion;
    }

    public double getRelativeHumidity() {
        return this.relativeHumidity;
    }

    public float getLocalTemperature() {
        return this.localTemperature;
    }

    public double getEnvRadiation() {
        return this.envRadiation;
    }

    private double getBlackGlobeTemp(class_3218 level, class_2338 pos, float dryTemp, double relativeHumidity) {
        this.envRadiation += EnvironmentData.getSunRadiation(level, pos);
        return TempHelper.getBlackGlobe(this.envRadiation, dryTemp, relativeHumidity);
    }

    private static double getBiomeHumidity(class_3218 level, class_6880<class_1959> biomeHolder, class_2338 pos) {
        double biomeHumidity;
        class_5217 info = level.method_8401();
        class_1959 biome = (class_1959)biomeHolder.comp_349();
        class_5268 serverInfo = homeostatic.platform.Services.PLATFORM.getServerLevelData(level);
        double maxRH = EnvironmentData.getMaxBiomeHumidity(level, biomeHolder, pos);
        double minRH = maxRH - 20.0;
        if (biome.method_48163()) {
            int nextRain = serverInfo.method_155();
            biomeHumidity = info.method_156() ? maxRH : (nextRain > 0 && nextRain <= 12000 ? minRH + (double)(20.0f * (1.0f - (float)nextRain / 12000.0f)) : minRH);
        } else {
            biomeHumidity = minRH;
        }
        return biomeHumidity;
    }

    private static double getSunRadiation(class_3218 level, class_2338 pos) {
        double radiation = 0.0;
        double sunlight = level.method_8314(class_1944.field_9284, pos.method_10084()) - level.method_8594();
        float f = level.method_8442(1.0f);
        if (sunlight > 0.0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            sunlight *= (double)class_3532.method_15362((float)f);
        }
        return Math.max(radiation += sunlight * 100.0, 0.0);
    }

    private static double getMaxBiomeHumidity(class_3218 level, class_6880<class_1959> biomeHolder, class_2338 pos) {
        BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome(biomeHolder);
        return biomeTypeData.getHumidity(((class_1959)biomeHolder.comp_349()).method_48162(pos, level.method_8615()));
    }

    private static float getWaterTemperature(float airTemperature, double waterVolume) {
        float waterTemp;
        float baseWaterTemp = 0.663f;
        if (airTemperature >= Environment.PARITY) {
            float increase = 0.1f + (float)(1.0 - waterVolume) * 0.35f;
            waterTemp = baseWaterTemp + (airTemperature - Environment.PARITY) * increase;
        } else {
            waterTemp = Math.max(baseWaterTemp - (Environment.PARITY - airTemperature) * 0.5f, 0.072f);
        }
        return waterTemp;
    }

    private static float getDayNightOffset(class_3218 level, class_6880<class_1959> biome, double relativeHumidity) {
        class_5321 worldKey = level.method_27983();
        if (!worldKey.method_29177().toString().contains(class_7134.field_37666.method_29177().toString())) {
            return 0.0f;
        }
        BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome(biome);
        long time = level.method_8532() % 24000L;
        HomeostaticClimateSettings climateSettings = climatesettings.platform.Services.CLIMATE.getClimateSettings(biome);
        float maxTemp = biomeTypeData.getDayNightOffset(climateSettings.getPrecipitationType());
        if (maxTemp == 0.0f) {
            return maxTemp;
        }
        float increaseTemp = maxTemp / 10000.0f;
        float decreaseTemp = maxTemp / 14000.0f;
        float humidityOffset = 1.0f - (float)(relativeHumidity / 100.0);
        float offset = time > 23000L ? (float)(24001L - time) * increaseTemp : (time < 9001L ? (float)(time + 1000L) * increaseTemp : maxTemp - (float)(time - 9000L) * decreaseTemp);
        return offset * humidityOffset;
    }

    private static float getHeightAdjustedTemperature(class_3218 level, class_6880<class_1959> biomeHolder, class_2338 pos) {
        class_5321 worldKey = level.method_27983();
        BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome(biomeHolder);
        class_1959.class_1963 precipitation = ((class_1959)biomeHolder.comp_349()).method_48162(pos, level.method_8615());
        float temperature = biomeTypeData.getTemperature(precipitation);
        if (!worldKey.method_29177().toString().contains(class_7134.field_37666.method_29177().toString())) {
            return temperature;
        }
        if (Services.PLATFORM.isModLoaded("primalwinter") && precipitation != class_1959.class_1963.field_9383) {
            temperature += -0.446f;
        }
        if (pos.method_10264() > 80) {
            float noise = (float)(TEMPERATURE_NOISE.method_16451((double)((float)pos.method_10263() / 8.0f), (double)((float)pos.method_10260() / 8.0f), false) * 8.0);
            return temperature - (noise + EnvironmentData.getAdjustedHeight(level, pos.method_10264()) - 80.0f) * 0.05f / 40.0f;
        }
        return temperature;
    }

    private static float getAdjustedHeight(class_3218 level, float y) {
        return y / ((float)level.method_31600() / 256.0f);
    }

    private static float getSeasonAdjustedTemperature(class_3218 level, class_6880<class_1959> biomeHolder, float biomeTemp, class_2338 pos) {
        class_5321 worldKey = level.method_27983();
        if (!worldKey.method_29177().toString().contains(class_7134.field_37666.method_29177().toString())) {
            return biomeTemp;
        }
        BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome(biomeHolder);
        SubSeason subSeasonHolder = homeostatic.platform.Services.PLATFORM.getSubSeason(level, biomeHolder);
        if (subSeasonHolder != null) {
            float lateSummerOffset = 0.022289157f * 5.0f;
            int subSeason = subSeasonHolder.ordinal();
            float variation = biomeTypeData.getSeasonVariation(((class_1959)biomeHolder.comp_349()).method_48162(pos, level.method_8615())) / 2.0f;
            int season = subSeason + 9 <= 12 ? subSeason + 9 : subSeason - 3;
            double temp = EnvironmentData.getSeasonTemperature(season, variation, biomeTemp);
            if (season == 2) {
                temp += (double)lateSummerOffset;
            }
            return (float)temp;
        }
        if (Services.PLATFORM.isModLoaded("primalwinter")) {
            int season = 7;
            float variation = biomeTypeData.getSeasonVariation(class_1959.class_1963.field_9382);
            double temp = EnvironmentData.getSeasonTemperature(season, variation, biomeTemp);
            return (float)temp;
        }
        return biomeTemp;
    }

    private static double getSeasonTemperature(int season, float variation, float biomeTemp) {
        return (double)variation * Math.cos((double)(season - 1) * Math.PI / 6.0) + (double)biomeTemp;
    }

    public static class_1959.class_1963 getPrecipitationAt(class_1959 biome, class_2338 pos, class_1937 level) {
        if (!biome.method_48163()) {
            return class_1959.class_1963.field_9384;
        }
        return EnvironmentData.coldEnoughToSnow(biome, pos, level) ? class_1959.class_1963.field_9383 : class_1959.class_1963.field_9382;
    }

    public static boolean coldEnoughToSnow(class_1959 biome, class_2338 pos, class_1937 level) {
        return !EnvironmentData.warmEnoughToRain(biome, pos, level);
    }

    public static boolean warmEnoughToRain(class_1959 biome, class_2338 pos, class_1937 level) {
        return biome.method_21740(pos, level.method_8615()) >= 0.15f;
    }

    public String toString() {
        return "EnvironmentData{isSubmerged=" + this.isSubmerged + ", isPartialSubmersion=" + this.isPartialSubmersion + ", relativeHumidity=" + this.relativeHumidity + ", airTemperature=" + this.airTemperature + ", waterTemperature=" + this.waterTemperature + ", localTemperature=" + this.localTemperature + ", envRadiation=" + this.envRadiation + "}";
    }
}

