/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.damagesource.HomeostaticDamageTypes;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.TemperatureRange;
import homeostatic.common.temperature.TemperatureThreshold;
import homeostatic.network.ITemperature;
import homeostatic.util.DamageHelper;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class Temperature
implements ITemperature {
    private float skinTemperature;
    private float lastSkinTemperature;
    private float coreTemperature;
    private float localTemperature;

    public Temperature() {
        this.skinTemperature = TemperatureThreshold.NORMAL.temperature;
        this.lastSkinTemperature = TemperatureThreshold.NORMAL.temperature;
        this.coreTemperature = TemperatureThreshold.NORMAL.temperature;
        this.localTemperature = 0.0f;
    }

    @Override
    public void setSkinTemperature(float skinTemperature) {
        this.skinTemperature = skinTemperature;
    }

    @Override
    public void setLastSkinTemperature(float lastSkinTemperature) {
        this.lastSkinTemperature = lastSkinTemperature;
    }

    @Override
    public void setCoreTemperature(float coreTemperature) {
        this.coreTemperature = coreTemperature;
    }

    @Override
    public void setLocalTemperature(float temperature) {
        this.localTemperature = temperature;
    }

    @Override
    public void setTemperatureData(float localTemperature, BodyTemperature bodyTemperature) {
        this.setSkinTemperature(bodyTemperature.getSkinTemperature());
        this.setLastSkinTemperature(bodyTemperature.getLastSkinTemperature());
        this.setCoreTemperature(bodyTemperature.getCoreTemperature());
        this.setLocalTemperature(localTemperature);
    }

    @Override
    public float getSkinTemperature() {
        return this.skinTemperature;
    }

    @Override
    public float getLastSkinTemperature() {
        return this.lastSkinTemperature;
    }

    @Override
    public float getCoreTemperature() {
        return this.coreTemperature;
    }

    @Override
    public float getLocalTemperature() {
        return this.localTemperature;
    }

    @Override
    public void checkTemperatureLevel(class_3222 player) {
        float amount;
        if (this.coreTemperature < TemperatureThreshold.LOW.temperature && !player.method_6059(class_7923.field_41174.method_47983((Object)HomeostaticEffects.FROST_RESISTANCE))) {
            player.method_32317(player.method_32312() + 5);
        } else if (this.coreTemperature > TemperatureThreshold.HIGH.temperature) {
            amount = (1.0f + (this.coreTemperature - TemperatureThreshold.HIGH.temperature)) * 0.5f;
            player.method_64397(player.method_51469(), new class_1282(DamageHelper.getHolder(player.method_51469().method_8503(), HomeostaticDamageTypes.HYPERTHERMIA)), amount);
        }
        if (this.skinTemperature > TemperatureThreshold.SCALDING.temperature) {
            amount = (1.0f + (this.skinTemperature - TemperatureThreshold.SCALDING.temperature)) * 0.25f;
            player.method_64397(player.method_51469(), new class_1282(DamageHelper.getHolder(player.method_51469().method_8503(), HomeostaticDamageTypes.SCALDING)), amount);
        }
    }

    @Override
    public class_2487 write(class_2487 tag) {
        tag.method_10548("skinTemperature", this.getSkinTemperature());
        tag.method_10548("lastSkinTemperature", this.getLastSkinTemperature());
        tag.method_10548("coreTemperature", this.getCoreTemperature());
        tag.method_10548("localTemperature", this.getLocalTemperature());
        return tag;
    }

    @Override
    public class_11372 write(class_11372 valueOutput) {
        valueOutput.method_71464("skinTemperature", this.getSkinTemperature());
        valueOutput.method_71464("lastSkinTemperature", this.getLastSkinTemperature());
        valueOutput.method_71464("coreTemperature", this.getCoreTemperature());
        valueOutput.method_71464("localTemperature", this.getLocalTemperature());
        return valueOutput;
    }

    @Override
    public void read(class_2487 tag) {
        this.setSkinTemperature(((Float)tag.method_10583("skinTemperature").orElseThrow()).floatValue());
        this.setLastSkinTemperature(((Float)tag.method_10583("lastSkinTemperature").orElseThrow()).floatValue());
        this.setCoreTemperature(((Float)tag.method_10583("coreTemperature").orElseThrow()).floatValue());
        this.setLocalTemperature(((Float)tag.method_10583("localTemperature").orElseThrow()).floatValue());
    }

    @Override
    public void read(class_11368 valueInput) {
        this.setSkinTemperature(valueInput.method_71423("skinTemperature", TemperatureThreshold.NORMAL.temperature));
        this.setLastSkinTemperature(valueInput.method_71423("lastSkinTemperature", TemperatureThreshold.NORMAL.temperature));
        this.setCoreTemperature(valueInput.method_71423("coreTemperature", TemperatureThreshold.NORMAL.temperature));
        this.setLocalTemperature(valueInput.method_71423("localTemperature", TemperatureRange.PARITY.temperature));
    }
}

