/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import homeostatic.config.ConfigHandler;
import homeostatic.overlay.EnhancedVisualsOverlay;
import homeostatic.overlay.HydrationOverlay;
import homeostatic.overlay.Overlay;
import homeostatic.overlay.TemperatureGlobeOverlay;
import homeostatic.overlay.TemperatureInfo;
import homeostatic.overlay.WaterHud;
import homeostatic.overlay.WetnessOverlay;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;

public class OverlayManager {
    public static final OverlayManager INSTANCE = new OverlayManager();
    public final WaterHud waterHud = new WaterHud();
    public final WetnessOverlay wetnessOverlay = new WetnessOverlay();
    public final TemperatureGlobeOverlay temperatureGlobeOverlay = new TemperatureGlobeOverlay();
    public final TemperatureInfo temperatureInfo = new TemperatureInfo();
    public final EnhancedVisualsOverlay enhancedVisualsOverlay = new EnhancedVisualsOverlay();
    public final HydrationOverlay hydrationOverlay = new HydrationOverlay();

    private OverlayManager() {
    }

    public void render(class_332 guiGraphics, Overlay overlay, boolean scaled, int rightHeight) {
        Matrix3x2fStack matrix = guiGraphics.method_51448();
        class_310 mc = class_310.method_1551();
        class_2338 pos = Objects.requireNonNull(mc.method_1560()).method_24515();
        if (mc.field_1687 != null && mc.field_1687.method_8477(pos)) {
            int scaledHeight;
            int scaledWidth;
            if (scaled) {
                float scale = (float)ConfigHandler.Client.scale();
                scaledWidth = (int)((float)mc.method_22683().method_4486() / scale);
                scaledHeight = (int)((float)mc.method_22683().method_4502() / scale);
                matrix.pushMatrix();
                matrix.scale(scale, scale);
            } else {
                scaledWidth = mc.method_22683().method_4486();
                scaledHeight = mc.method_22683().method_4502() - rightHeight;
                matrix.pushMatrix();
            }
            overlay.render(guiGraphics, mc, pos, scaledWidth, scaledHeight);
            matrix.popMatrix();
        }
    }

    public void renderOverlay(class_332 guiGraphics) {
        this.render(guiGraphics, this.temperatureInfo, true, 0);
    }

    public void renderWaterOverlay(class_332 guiGraphics, int rightHeight) {
        if (ConfigHandler.Client.forceWaterBarPosition()) {
            rightHeight = 0;
        }
        this.render(guiGraphics, this.waterHud, false, rightHeight);
        this.render(guiGraphics, this.wetnessOverlay, false, 0);
    }

    public void renderTemperatureOverlay(class_332 guiGraphics) {
        this.render(guiGraphics, this.temperatureGlobeOverlay, false, 0);
    }

    public void renderEnhancedVisualsOverlay(class_332 guiGraphics) {
        this.render(guiGraphics, this.enhancedVisualsOverlay, false, 0);
    }

    public void renderHydrationOverlay(class_332 guiGraphics, int rightHeight) {
        this.render(guiGraphics, this.hydrationOverlay, false, rightHeight);
    }
}

