/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.block;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.block.BlockRadiation;
import homeostatic.platform.Services;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class BlockRadiationManager
extends class_4309 {
    private static final Map<class_2248, BlockRadiation> RADIATION_BLOCKS = new HashMap<class_2248, BlockRadiation>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockRadiation.class, (Object)new BlockRadiation.Serializer()).create();

    public BlockRadiationManager() {
        super(GSON, "environment/block_radiation");
    }

    public static JsonElement parseBlockRadiation(BlockRadiation blockRadiation) {
        return GSON.toJsonTree((Object)blockRadiation);
    }

    public static BlockRadiation getBlockRadiation(class_2248 block) {
        return RADIATION_BLOCKS.get(block);
    }

    protected void apply(Map<class_2960, JsonElement> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        RADIATION_BLOCKS.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            try {
                BlockRadiation blockRadiation = (BlockRadiation)GSON.fromJson(entry.getValue(), BlockRadiation.class);
                class_2248 block = Services.PLATFORM.getBlock(blockRadiation.loc());
                if (block == class_2246.field_10124 || block == null) continue;
                RADIATION_BLOCKS.put(block, blockRadiation);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse block radiation {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} radiation blocks", (Object)RADIATION_BLOCKS.size());
    }
}

