/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.fluid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.fluid.DrinkingFluid;
import homeostatic.platform.Services;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class DrinkingFluidManager
extends class_4309 {
    private static final Map<class_3611, DrinkingFluid> FLUIDS = new HashMap<class_3611, DrinkingFluid>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DrinkingFluid.class, (Object)new DrinkingFluid.Serializer()).create();

    public DrinkingFluidManager() {
        super(GSON, "environment/fluids");
    }

    public static JsonElement parseDrinkingFluid(DrinkingFluid drinkingFluid) {
        return GSON.toJsonTree((Object)drinkingFluid);
    }

    public static DrinkingFluid get(class_3611 fluid) {
        return FLUIDS.get(fluid);
    }

    public static void write(class_2540 buf) {
        buf.writeInt(FLUIDS.size());
        for (Map.Entry<class_3611, DrinkingFluid> entry : FLUIDS.entrySet()) {
            class_2487 drinkingFluidTag = DrinkingFluid.serialize(entry.getValue());
            buf.method_10812(Services.PLATFORM.getFluidResourceLocation(entry.getKey()));
            buf.method_10794(drinkingFluidTag);
        }
    }

    public static class_2499 write() {
        class_2499 tag = new class_2499();
        for (Map.Entry<class_3611, DrinkingFluid> entry : FLUIDS.entrySet()) {
            class_2487 drinkingFluidTag = DrinkingFluid.serialize(entry.getValue());
            tag.add((Object)drinkingFluidTag);
        }
        return tag;
    }

    public static void read(class_2540 buf) {
        int size = buf.method_10816();
        if (size <= 0) {
            return;
        }
        FLUIDS.clear();
        for (int i = 0; i < size; ++i) {
            class_2960 fluidLoc = buf.method_10810();
            class_2487 drinkingFluidTag = buf.method_10798();
            class_3611 fluid = Services.PLATFORM.getFluid(fluidLoc);
            if (fluid == class_3612.field_15906 || fluid == null || drinkingFluidTag == null) continue;
            DrinkingFluid drinkingFluid = DrinkingFluid.deserialize(drinkingFluidTag);
            FLUIDS.put(fluid, drinkingFluid);
        }
        Homeostatic.LOGGER.info("Synchronized {} drinking fluids", (Object)FLUIDS.size());
    }

    public static void read(class_2499 tag) {
        if (tag == null || tag.isEmpty()) {
            return;
        }
        FLUIDS.clear();
        for (int i = 0; i < tag.size(); ++i) {
            class_2487 drinkingFluidTag = tag.method_10602(i);
            DrinkingFluid drinkingFluid = DrinkingFluid.deserialize(drinkingFluidTag);
            class_3611 fluid = Services.PLATFORM.getFluid(drinkingFluid.loc());
            if (fluid == class_3612.field_15906 || fluid == null) continue;
            FLUIDS.put(fluid, drinkingFluid);
        }
        Homeostatic.LOGGER.info("Loaded {} drinking fluids from NBT", (Object)FLUIDS.size());
    }

    protected void apply(Map<class_2960, JsonElement> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        FLUIDS.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            try {
                DrinkingFluid drinkingFluid = (DrinkingFluid)GSON.fromJson(entry.getValue(), DrinkingFluid.class);
                class_3611 fluid = Services.PLATFORM.getFluid(drinkingFluid.loc());
                if (fluid == class_3612.field_15906 || fluid == null) continue;
                FLUIDS.put(fluid, drinkingFluid);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse drinking fluid {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded {} drinking fluids", (Object)FLUIDS.size());
    }
}

