/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.temperature;

import homeostatic.common.TagManager;
import homeostatic.common.block.BlockRadiation;
import homeostatic.common.block.BlockRadiationManager;
import homeostatic.common.temperature.EnvironmentInfo;
import homeostatic.common.temperature.TemperatureRange;
import homeostatic.config.ConfigHandler;
import homeostatic.util.VecMath;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2841;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_7134;
import org.joml.Vector3d;

public class Environment {
    public static final float PARITY = TemperatureRange.PARITY.temperature;
    public static final float PARITY_LOW = TemperatureRange.PARITY_LOW.temperature;
    public static final float PARITY_HIGH = TemperatureRange.PARITY_HIGH.temperature;
    public static final float HOT = TemperatureRange.HOT.temperature;
    public static final float EXTREME_HEAT = TemperatureRange.EXTREME_HEAT.temperature;
    public static final float EXTREME_COLD = TemperatureRange.EXTREME_COLD.temperature;

    public static EnvironmentInfo get(class_3218 world, class_3222 sp) {
        double radiation = 0.0;
        double waterVolume = 0.0;
        double waterBlocks = 0.0;
        double totalBlocks = 0.0;
        AtomicReference<Double> radiationReduction = new AtomicReference<Double>(1.0);
        HashMap<class_1923, class_2818> chunkMap = new HashMap<class_1923, class_2818>();
        class_2338 pos = sp.method_24515();
        class_243 spPos = sp.method_5836(1.0f);
        class_2338 eyePos = new class_2338((int)spPos.method_10216(), (int)spPos.method_10214(), (int)spPos.method_10215());
        class_5321 worldKey = world.method_27983();
        class_1293 effectInstance = sp.method_6112(class_1294.field_5918);
        boolean inOverworld = worldKey.method_29177().toString().contains(class_7134.field_37666.method_29177().toString());
        boolean isSubmerged = sp.method_5869() && sp.method_5799() && sp.method_5637();
        boolean isSheltered = true;
        boolean isUnderground = true;
        if (!inOverworld) {
            isUnderground = false;
            isSheltered = false;
        }
        if (isSubmerged) {
            isSheltered = false;
        }
        sp.method_5661().forEach(armor -> {
            class_2487 tags = armor.method_7969();
            if (tags != null && tags.method_10545("radiation_protection") || armor.method_31573(TagManager.Items.RADIATION_PROTECTED_ARMOR)) {
                radiationReduction.updateAndGet(v -> v - (double)ConfigHandler.Common.getRadiationReductionPercent());
            }
        });
        for (int x = -12; x <= 12; ++x) {
            for (int z = -12; z <= 12; ++z) {
                if (isSheltered && x <= 2 && x >= -2 && z <= 2 && z >= -2) {
                    isSheltered = !world.method_8311(eyePos.method_10069(x, 0, z).method_10084());
                }
                for (int y = -3; y <= 11; ++y) {
                    BlockRadiation blockRadiation;
                    class_2841 palette;
                    class_1923 chunkPos = new class_1923(pos.method_10263() + x >> 4, pos.method_10260() + z >> 4);
                    class_2818 chunk = Environment.getChunk((class_1937)world, chunkPos, chunkMap);
                    if (chunk == null) continue;
                    class_2338 blockpos = pos.method_10069(x, y, z);
                    try {
                        palette = chunk.method_38259((blockpos.method_10264() >> 4) - chunk.method_32891()).method_12265();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    class_2680 state = (class_2680)palette.method_12321(blockpos.method_10263() & 0xF, blockpos.method_10264() & 0xF, blockpos.method_10260() & 0xF);
                    boolean isWater = state.method_27852(class_2246.field_10382);
                    if (isUnderground && y >= 0 && !isWater) {
                        boolean bl = isUnderground = !world.method_8311(eyePos.method_10069(x, y, z).method_10084());
                    }
                    if (x <= 5 && x >= -5 && y <= 5 && z <= 5 && z >= -5) {
                        totalBlocks += 1.0;
                        if (isWater) {
                            waterBlocks += 1.0;
                        }
                    }
                    if (state.method_26215() || y > 3 || effectInstance != null || (blockRadiation = BlockRadiationManager.getBlockRadiation(state.method_26204())) == null) continue;
                    boolean hasRadiation = true;
                    if (state.method_28498((class_2769)class_2741.field_12548)) {
                        hasRadiation = (Boolean)state.method_11654((class_2769)class_2741.field_12548);
                    }
                    if (hasRadiation && Objects.requireNonNull(state.method_26204().toString()).contains("campfire")) {
                        for (int i = 1; i <= 5; ++i) {
                            if (!hasRadiation || !world.method_8320(blockpos.method_10086(i)).method_26164(class_3481.field_20340)) continue;
                            hasRadiation = false;
                        }
                    }
                    if (!hasRadiation) continue;
                    class_243 vPos = new class_243((double)blockpos.method_10263() + 0.5, (double)blockpos.method_10264() + 0.5, (double)blockpos.method_10260() + 0.5);
                    double distance = VecMath.getDistance(sp, new Vector3d(vPos.field_1352, vPos.field_1351, vPos.field_1350));
                    boolean obscured = VecMath.isBlockObscured(sp, vPos);
                    if (!state.method_26227().method_15769()) {
                        double amount = (double)state.method_26227().method_15761() / 8.0;
                        radiation += blockRadiation.getBlockRadiation(state, distance, obscured, amount, y);
                        continue;
                    }
                    radiation += blockRadiation.getBlockRadiation(state, distance, obscured, y);
                }
            }
        }
        waterVolume = waterBlocks == 0.0 ? 0.0 : waterBlocks / totalBlocks;
        return new EnvironmentInfo(isUnderground, isSheltered, radiation *= radiationReduction.get().doubleValue(), waterVolume);
    }

    private static class_2818 getChunk(class_1937 world, class_1923 pos, Map<class_1923, class_2818> chunks) {
        class_2818 chunk;
        class_1923 chunkPos = new class_1923(pos.field_9181, pos.field_9180);
        if (chunks.containsKey(chunkPos)) {
            chunk = chunks.get(chunkPos);
        } else {
            chunk = world.method_8398().method_21730(chunkPos.field_9181, chunkPos.field_9180);
            chunks.put(chunkPos, chunk);
        }
        return chunk;
    }
}

