/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import com.google.gson.JsonElement;
import homeostatic.common.block.BlockRadiation;
import homeostatic.common.block.BlockRadiationManager;
import homeostatic.data.integration.ModIntegration;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

public class RadiationBlocksProvider
implements class_2405 {
    private final Map<class_2960, BlockRadiation> RADIATION_MAP = new HashMap<class_2960, BlockRadiation>();
    private final class_7784 packOutput;

    public RadiationBlocksProvider(@NotNull class_7784 packOutput) {
        this.packOutput = packOutput;
    }

    protected void registerRadiationBlocks() {
        this.add(ModIntegration.mcNamespaceLoc("soul_campfire"), 8325.0);
        this.add(ModIntegration.mcNamespaceLoc("campfire"), 5550.0);
        this.add(ModIntegration.mcNamespaceLoc("soul_fire"), 1950.0);
        this.add(ModIntegration.mcNamespaceLoc("blast_furnace"), 1800.0);
        this.add(ModIntegration.mcNamespaceLoc("lava"), 1550.0);
        this.add(ModIntegration.mcNamespaceLoc("fire"), 1300.0);
        this.add(ModIntegration.mcNamespaceLoc("furnace"), 1300.0);
        this.add(ModIntegration.mcNamespaceLoc("magma_block"), 1200.0);
        this.add(ModIntegration.mcNamespaceLoc("smoker"), 1100.0);
        this.add(ModIntegration.mcNamespaceLoc("soul_torch"), 525.0);
        this.add(ModIntegration.mcNamespaceLoc("soul_wall_torch"), 525.0);
        this.add(ModIntegration.mcNamespaceLoc("soul_lantern"), 525.0);
        this.add(ModIntegration.mcNamespaceLoc("nether_portal"), 350.0);
        this.add(ModIntegration.mcNamespaceLoc("torch"), 350.0);
        this.add(ModIntegration.mcNamespaceLoc("wall_torch"), 350.0);
        this.add(ModIntegration.mcNamespaceLoc("lantern"), 350.0);
        this.add(ModIntegration.createLoc("blaze_burner"), 8325.0);
        this.add(ModIntegration.createLoc("lit_blaze_burner"), 8325.0);
        this.add(ModIntegration.tconLoc("smeltery_controller"), 5550.0);
        this.add(ModIntegration.tconLoc("foundry_controller"), 5550.0);
        this.add(ModIntegration.tconLoc("seared_melter"), 2450.0);
        this.add(ModIntegration.tconLoc("seared_heater"), 2450.0);
        this.add(ModIntegration.tconLoc("scorched_alloyer"), 2450.0);
    }

    protected void add(class_2960 loc, double maxRadiation) {
        this.RADIATION_MAP.put(loc, new BlockRadiation(loc, maxRadiation));
    }

    public String method_10321() {
        return "Homeostatic - Block Radiation ";
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 cache) throws IllegalStateException {
        ArrayList<CompletableFuture> recipeList = new ArrayList<CompletableFuture>();
        this.registerRadiationBlocks();
        for (Map.Entry<class_2960, BlockRadiation> entry : this.RADIATION_MAP.entrySet()) {
            class_7784.class_7489 pathProvider = this.getPath(entry.getKey());
            recipeList.add(class_2405.method_10320((class_7403)cache, (JsonElement)BlockRadiationManager.parseBlockRadiation(entry.getValue()), (Path)pathProvider.method_44107(entry.getKey())));
        }
        return CompletableFuture.allOf((CompletableFuture[])recipeList.toArray(CompletableFuture[]::new));
    }

    private class_7784.class_7489 getPath(class_2960 loc) {
        return this.packOutput.method_45973(class_7784.class_7490.field_39367, "environment/block_radiation/");
    }
}

