/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.event;

import homeostatic.common.capabilities.ITemperature;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.EnvironmentData;
import homeostatic.common.temperature.ThermometerInfo;
import homeostatic.common.water.WaterInfo;
import homeostatic.config.ConfigHandler;
import homeostatic.platform.Services;
import homeostatic.util.WaterHelper;
import homeostatic.util.WetnessHelper;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3695;
import net.minecraft.class_6880;

public class PlayerEventHandler {
    public static void onEntityJoinLevel(class_3222 sp) {
        class_3218 world = sp.method_51469();
        if (sp.field_13974.method_14257() != class_1934.field_9215) {
            return;
        }
        WaterHelper.updateWaterInfo(sp, 0.0f);
        WetnessHelper.updateWetnessInfo(sp, 0.0f, true);
        Services.PLATFORM.getTemperatureData((class_1657)sp).ifPresent(data -> {
            class_243 spPos = sp.method_5836(1.0f);
            class_2338 pos = new class_2338((int)spPos.method_10216(), (int)spPos.method_10214(), (int)spPos.method_10215());
            class_6880 biome = world.method_23753(pos);
            EnvironmentData environmentData = new EnvironmentData(sp, pos, (class_6880<class_1959>)biome, world);
            BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, (ITemperature)data);
            Services.PLATFORM.syncTemperatureData(sp, environmentData, bodyTemperature);
        });
    }

    public static void onPlayerTickEvent(class_3222 sp) {
        if (sp.field_13974.method_14257() != class_1934.field_9215) {
            return;
        }
        class_3218 world = sp.method_51469();
        class_3695 profilerfiller = world.method_16107();
        Services.PLATFORM.getWaterCapabilty((class_1657)sp).ifPresent(data -> data.checkWaterLevel(sp));
        profilerfiller.method_15396("tempCalc");
        Services.PLATFORM.getTemperatureData((class_1657)sp).ifPresent(data -> {
            if (sp.field_6012 % 2 == 0) {
                data.checkTemperatureLevel((class_1657)sp);
            }
            if (sp.field_6012 % 16 == 0 || sp.field_6012 % 60 == 0) {
                class_243 spPos = sp.method_5836(1.0f);
                class_2338 pos = new class_2338((int)spPos.method_10216(), (int)spPos.method_10214(), (int)spPos.method_10215());
                class_6880 biome = world.method_23753(pos);
                EnvironmentData environmentData = new EnvironmentData(sp, pos, (class_6880<class_1959>)biome, world);
                boolean updateCore = sp.field_6012 % 60 == 0;
                BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, (ITemperature)data, updateCore, true);
                data.setTemperatureData(environmentData.getLocalTemperature(), bodyTemperature);
                Services.PLATFORM.syncTemperatureData(sp, environmentData, bodyTemperature);
            }
        });
        profilerfiller.method_15407();
    }

    public static void onPlayerRespawn(class_3222 sp) {
        class_3218 world = sp.method_51469();
        if (sp.field_13974.method_14257() != class_1934.field_9215) {
            return;
        }
        Services.PLATFORM.getWaterCapabilty((class_1657)sp).ifPresent(data -> {
            WaterInfo waterInfo = new WaterInfo(10, 2.5f, 0.0f);
            data.setWaterData(waterInfo);
            Services.PLATFORM.syncWaterData(sp, waterInfo);
        });
        Services.PLATFORM.getTemperatureData((class_1657)sp).ifPresent(data -> {
            class_243 spPos = sp.method_5836(1.0f);
            class_2338 pos = new class_2338((int)spPos.method_10216(), (int)spPos.method_10214(), (int)spPos.method_10215());
            class_6880 biome = world.method_23753(pos);
            EnvironmentData environmentData = new EnvironmentData(sp, pos, (class_6880<class_1959>)biome, world);
            BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, (ITemperature)data);
            data.setTemperatureData(environmentData.getLocalTemperature(), bodyTemperature);
            Services.PLATFORM.syncTemperatureData(sp, environmentData, bodyTemperature);
        });
    }

    public static void onEquipmentChange(class_1309 entity, class_1304 slot, class_1799 previousItem, class_1799 equippedItem) {
        if (ConfigHandler.Common.showTemperatureValues() && ConfigHandler.Common.requireThermometer() && slot == class_1304.field_6169 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!player.method_37908().field_9236) {
                class_3222 sp = (class_3222)player;
                Services.PLATFORM.getThermometerCapability((class_1657)sp).ifPresent(data -> {
                    boolean equippedHasThermometer = PlayerEventHandler.hasThermometer(equippedItem);
                    ThermometerInfo info = new ThermometerInfo(equippedHasThermometer);
                    Services.PLATFORM.syncThermometerData(sp, info);
                });
            }
        }
    }

    private static boolean hasThermometer(class_1799 helmet) {
        class_2487 tag = helmet.method_7948();
        return tag.method_10545("thermometer");
    }
}

