/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.platform;

import homeostatic.common.biome.ClimateSettings;
import homeostatic.common.capabilities.ITemperature;
import homeostatic.common.capabilities.IThermometer;
import homeostatic.common.capabilities.IWater;
import homeostatic.common.capabilities.IWetness;
import homeostatic.common.components.HomeostaticComponents;
import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.item.IItemStackFluid;
import homeostatic.common.item.LeatherFlask;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.EnvironmentData;
import homeostatic.common.temperature.SubSeason;
import homeostatic.common.temperature.ThermometerInfo;
import homeostatic.common.water.WaterInfo;
import homeostatic.common.wetness.WetnessInfo;
import homeostatic.mixin.FabricBiomeAccessor;
import homeostatic.mixin.ServerLevelAccessor;
import homeostatic.platform.services.IPlatform;
import homeostatic.util.CreateHelper;
import homeostatic.util.FabricSeasonsHelper;
import homeostatic.util.ItemStackFluidHelper;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_5268;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import technology.roughness.whitenoise.platform.Services;

public class FabricPlatform
implements IPlatform {
    @Override
    public class_2960 getFluidResourceLocation(class_3611 fluid) {
        return class_7923.field_41173.method_10221((Object)fluid);
    }

    @Override
    public boolean isModLoaded(String name) {
        return Services.PLATFORM.isModLoaded(name);
    }

    @Override
    public double getCreateBlockRadiation(class_2680 state, Double radiation) {
        return CreateHelper.getBlockRadiation(state, radiation);
    }

    @Override
    public class_2248 getBlock(class_2960 loc) {
        return (class_2248)class_7923.field_41175.method_10223(loc);
    }

    @Override
    public class_3611 getFluid(class_2960 loc) {
        return (class_3611)class_7923.field_41173.method_10223(loc);
    }

    @Override
    public class_1792 getItem(class_2960 loc) {
        return (class_1792)class_7923.field_41178.method_10223(loc);
    }

    @Override
    public String fluidStackTag() {
        return "Fluid";
    }

    @Override
    public Optional<FluidInfo> getFluidInfo(class_1799 stack) {
        if (stack.method_7909() instanceof IItemStackFluid) {
            return Optional.of(ItemStackFluidHelper.getFluidInfo(stack));
        }
        return Optional.empty();
    }

    @Override
    public class_1799 drainFluid(class_1799 stack, long amount) {
        if (stack.method_7909() instanceof IItemStackFluid) {
            ItemStackFluidHelper.drainFluid(stack, amount);
        }
        return stack;
    }

    @Override
    public class_1799 fillFluid(class_1799 stack, class_3611 fluid, long amount) {
        if (stack.method_7909() instanceof IItemStackFluid) {
            ItemStackFluidHelper.fillFluid(stack, fluid, amount);
        }
        return stack;
    }

    @Override
    public long getFluidCapacity(class_1799 stack) {
        if (stack.method_7909() instanceof LeatherFlask) {
            return 1000L;
        }
        return 0L;
    }

    @Override
    public class_2561 getDisplayName(class_3611 fluid) {
        return fluid.method_15785().method_15759().method_26204().method_9518();
    }

    @Override
    public ClimateSettings getClimateSettings(class_6880<class_1959> biomeHolder) {
        class_1959.class_5482 climateSettings = ((FabricBiomeAccessor)biomeHolder.comp_349()).homoestatic$getClimateSettings();
        return new ClimateSettings(biomeHolder, climateSettings.comp_1187(), climateSettings.comp_844(), climateSettings.comp_845(), climateSettings.comp_846());
    }

    @Override
    public SubSeason getSubSeason(class_3218 level, class_6880<class_1959> biomeHolder) {
        if (this.isModLoaded("seasons") && FabricSeasonsHelper.isSeasonDimension((class_1937)level)) {
            return SubSeason.getSubSeason((class_1937)level, FabricSeasonsHelper.getSeasonDuration());
        }
        return null;
    }

    @Override
    public Optional<? extends ITemperature> getTemperatureData(class_1657 player) {
        return HomeostaticComponents.TEMPERATURE_DATA.maybeGet((Object)player);
    }

    @Override
    public void syncTemperatureData(class_3222 sp, EnvironmentData environmentData, BodyTemperature bodyTemperature) {
        HomeostaticComponents.TEMPERATURE_DATA.sync((Object)sp);
    }

    @Override
    public Optional<? extends IThermometer> getThermometerCapability(class_1657 player) {
        return HomeostaticComponents.THERMOMETER_DATA.maybeGet((Object)player);
    }

    @Override
    public void syncThermometerData(class_3222 sp, ThermometerInfo info) {
        HomeostaticComponents.THERMOMETER_DATA.sync((Object)sp);
    }

    @Override
    public Optional<? extends IWater> getWaterCapabilty(class_1657 player) {
        return HomeostaticComponents.WATER_DATA.maybeGet((Object)player);
    }

    @Override
    public void syncWaterData(class_3222 sp, WaterInfo waterInfo) {
        HomeostaticComponents.WATER_DATA.sync((Object)sp);
    }

    @Override
    public Optional<? extends IWetness> getWetnessCapability(class_1657 player) {
        return HomeostaticComponents.WETNESS_DATA.maybeGet((Object)player);
    }

    @Override
    public void syncWetnessData(class_3222 sp, WetnessInfo wetnessInfo) {
        HomeostaticComponents.WETNESS_DATA.sync((Object)sp);
    }

    @Override
    public class_5268 getServerLevelData(class_3218 level) {
        ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
        return serverLevel.getServerLevelData();
    }

    @Override
    public void syncFluidData(class_3222 sp) {
    }
}

