/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.block;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import homeostatic.util.TConHelper;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import technology.roughness.whitenoise.platform.Services;
import technology.roughness.whitenoise.util.ResourceLocationHelper;

public record BlockRadiation(ResourceLocation loc, double maxRadiation) {
    public double getBlockRadiation(BlockState state, double distance, boolean obscured, int y) {
        double radiation = distance <= 1.0 ? this.maxRadiation(state) : this.maxRadiation(state) / distance;
        if (y > 0 && y < 5) {
            radiation *= (double)(4 - y) * 0.25;
        }
        if (obscured) {
            radiation *= 0.9;
        }
        return Math.min(radiation, this.maxRadiation(state));
    }

    public double getBlockRadiation(BlockState state, double distance, boolean obscured, double amount, int y) {
        double radiation = 0.0;
        if (amount <= 0.0) {
            return radiation;
        }
        radiation = distance <= 1.0 ? this.maxRadiation(state) : this.maxRadiation(state) * amount / distance;
        if (y > 0 && y < 5) {
            radiation *= (double)(4 - y) * 0.25;
        }
        if (obscured) {
            radiation *= 0.9;
        }
        return Math.min(radiation, this.maxRadiation(state));
    }

    public double maxRadiation(BlockState state) {
        Block block = state.getBlock();
        if (Services.PLATFORM.isModLoaded("create") && block.toString().contains("create")) {
            return homeostatic.platform.Services.PLATFORM.getCreateBlockRadiation(state, this.maxRadiation);
        }
        if (Services.PLATFORM.isModLoaded("tconstruct") && block.toString().contains("tconstruct")) {
            return TConHelper.getBlockRadiation(state, this.maxRadiation);
        }
        return this.maxRadiation;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BlockRadiation that = (BlockRadiation)obj;
        return Objects.equals(this.loc, that.loc) && Double.doubleToLongBits(this.maxRadiation) == Double.doubleToLongBits(that.maxRadiation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.loc, this.maxRadiation);
    }

    @Override
    public String toString() {
        return "BlockRadiation[loc=" + String.valueOf(this.loc) + ", maxRadiation=" + this.maxRadiation + "]";
    }

    public static class Serializer
    implements JsonDeserializer<BlockRadiation>,
    JsonSerializer<BlockRadiation> {
        public BlockRadiation deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = GsonHelper.convertToJsonObject((JsonElement)jsonElement, (String)"data");
            return new BlockRadiation(ResourceLocationHelper.parse((String)json.get("block").getAsString()), json.get("max_radiation").getAsDouble());
        }

        public JsonElement serialize(BlockRadiation blockRadiation, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("block", blockRadiation.loc().toString());
            json.addProperty("max_radiation", (Number)blockRadiation.maxRadiation());
            return json;
        }
    }
}

