/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import homeostatic.platform.Services;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PurifiedWaterBottle
extends Item {
    public PurifiedWaterBottle(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemUseAnimation getUseAnimation(@NotNull ItemStack stack) {
        return ItemUseAnimation.DRINK;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 32;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        if (this.canDrink(player)) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        Player player;
        Player player2 = player = entity instanceof Player ? (Player)entity : null;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CriteriaTriggers.CONSUME_ITEM.trigger(sp, stack);
        }
        stack.setCount(stack.getCount() - 1);
        return stack;
    }

    private boolean canDrink(Player player) {
        AtomicBoolean canDrink = new AtomicBoolean(false);
        Services.PLATFORM.getWaterCapabilty(player).ifPresent(data -> canDrink.set(data.getWaterLevel() < 20));
        return canDrink.get();
    }
}

