/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.recipe;

import com.mojang.datafixers.util.Pair;
import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.item.LeatherFlask;
import homeostatic.common.recipe.HomeostaticRecipes;
import homeostatic.platform.Services;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PurifiedLeatherFlask
extends CustomRecipe {
    public PurifiedLeatherFlask(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput craftingInput, @NotNull Level level) {
        Pair<ItemStack, ItemStack> check = this.checkContainer(craftingInput);
        ItemStack flask = (ItemStack)check.getFirst();
        ItemStack filter = (ItemStack)check.getSecond();
        return flask != null && filter != null;
    }

    public ItemStack assemble(@NotNull CraftingInput craftingInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        Pair<ItemStack, ItemStack> check = this.checkContainer(craftingInput);
        ItemStack flaskCopy = ((ItemStack)check.getFirst()).copy();
        FluidInfo fluidInfo = Services.PLATFORM.getFluidInfo(flaskCopy).get();
        int amount = (int)fluidInfo.amount();
        Services.PLATFORM.drainFluid(flaskCopy, amount);
        return Services.PLATFORM.fillFluid(flaskCopy, HomeostaticFluids.PURIFIED_WATER, amount);
    }

    public RecipeSerializer<PurifiedLeatherFlask> getSerializer() {
        return HomeostaticRecipes.PURIFIED_LEATHER_FLASK_SERIALIZER;
    }

    public Pair<ItemStack, ItemStack> checkContainer(CraftingInput craftingInput) {
        ItemStack flask = null;
        ItemStack filter = null;
        for (int i = 0; i < craftingInput.size(); ++i) {
            FluidInfo fluidInfo;
            ItemStack ingredient = craftingInput.getItem(i);
            if (ingredient.is(HomeostaticItems.WATER_FILTER)) {
                filter = ingredient;
                continue;
            }
            if (!(ingredient.getItem() instanceof LeatherFlask) || (fluidInfo = Services.PLATFORM.getFluidInfo(ingredient).get()).amount() <= 0L) continue;
            flask = ingredient;
        }
        return Pair.of(flask, filter);
    }

    public static class Type
    implements RecipeType<PurifiedLeatherFlask> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

