/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.fluid.DrinkingFluid;
import homeostatic.common.fluid.DrinkingFluidManager;
import homeostatic.data.integration.ModIntegration;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DrinkingFluidsProvider
implements DataProvider {
    private final Map<ResourceLocation, DrinkingFluid> DRINKING_FLUIDS = new HashMap<ResourceLocation, DrinkingFluid>();
    private final PackOutput packOutput;

    public DrinkingFluidsProvider(@NotNull PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    protected void addDrinkingFluids() {
        this.add(ModIntegration.mcLoc("water"), 1, 0.0f, 45, 200, 0.2f);
        this.add(Homeostatic.prefix("purified_water"), 3, 0.7f, 0, 0, 0.0f);
    }

    protected void add(ResourceLocation loc, int amount, float saturation, int potency, int duration, float chance) {
        this.DRINKING_FLUIDS.put(loc, new DrinkingFluid(loc, amount, saturation, potency, duration, chance));
    }

    public String getName() {
        return "Homeostatic - Drinking Fluids";
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) throws IllegalStateException {
        ArrayList<CompletableFuture> recipeList = new ArrayList<CompletableFuture>();
        this.addDrinkingFluids();
        for (Map.Entry<ResourceLocation, DrinkingFluid> entry : this.DRINKING_FLUIDS.entrySet()) {
            PackOutput.PathProvider pathProvider = this.getPath(entry.getKey());
            recipeList.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)DrinkingFluidManager.parseDrinkingFluid(entry.getValue()), (Path)pathProvider.json(entry.getKey())));
        }
        return CompletableFuture.allOf((CompletableFuture[])recipeList.toArray(CompletableFuture[]::new));
    }

    private PackOutput.PathProvider getPath(ResourceLocation loc) {
        return this.packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "environment/fluids/");
    }
}

