/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.damagesource.HomeostaticDamageTypes;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.TemperatureRange;
import homeostatic.common.temperature.TemperatureThreshold;
import homeostatic.network.ITemperature;
import homeostatic.util.DamageHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class Temperature
implements ITemperature {
    private float skinTemperature;
    private float lastSkinTemperature;
    private float coreTemperature;
    private float localTemperature;

    public Temperature() {
        this.skinTemperature = TemperatureThreshold.NORMAL.temperature;
        this.lastSkinTemperature = TemperatureThreshold.NORMAL.temperature;
        this.coreTemperature = TemperatureThreshold.NORMAL.temperature;
        this.localTemperature = 0.0f;
    }

    @Override
    public void setSkinTemperature(float skinTemperature) {
        this.skinTemperature = skinTemperature;
    }

    @Override
    public void setLastSkinTemperature(float lastSkinTemperature) {
        this.lastSkinTemperature = lastSkinTemperature;
    }

    @Override
    public void setCoreTemperature(float coreTemperature) {
        this.coreTemperature = coreTemperature;
    }

    @Override
    public void setLocalTemperature(float temperature) {
        this.localTemperature = temperature;
    }

    @Override
    public void setTemperatureData(float localTemperature, BodyTemperature bodyTemperature) {
        this.setSkinTemperature(bodyTemperature.getSkinTemperature());
        this.setLastSkinTemperature(bodyTemperature.getLastSkinTemperature());
        this.setCoreTemperature(bodyTemperature.getCoreTemperature());
        this.setLocalTemperature(localTemperature);
    }

    @Override
    public float getSkinTemperature() {
        return this.skinTemperature;
    }

    @Override
    public float getLastSkinTemperature() {
        return this.lastSkinTemperature;
    }

    @Override
    public float getCoreTemperature() {
        return this.coreTemperature;
    }

    @Override
    public float getLocalTemperature() {
        return this.localTemperature;
    }

    @Override
    public void checkTemperatureLevel(ServerPlayer player) {
        float amount;
        if (this.coreTemperature < TemperatureThreshold.LOW.temperature && !player.hasEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)HomeostaticEffects.FROST_RESISTANCE))) {
            player.setTicksFrozen(player.getTicksFrozen() + 5);
        } else if (this.coreTemperature > TemperatureThreshold.HIGH.temperature) {
            amount = (1.0f + (this.coreTemperature - TemperatureThreshold.HIGH.temperature)) * 0.5f;
            player.hurtServer(player.level(), new DamageSource(DamageHelper.getHolder(player.level().getServer(), HomeostaticDamageTypes.HYPERTHERMIA)), amount);
        }
        if (this.skinTemperature > TemperatureThreshold.SCALDING.temperature) {
            amount = (1.0f + (this.skinTemperature - TemperatureThreshold.SCALDING.temperature)) * 0.25f;
            player.hurtServer(player.level(), new DamageSource(DamageHelper.getHolder(player.level().getServer(), HomeostaticDamageTypes.SCALDING)), amount);
        }
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        tag.putFloat("skinTemperature", this.getSkinTemperature());
        tag.putFloat("lastSkinTemperature", this.getLastSkinTemperature());
        tag.putFloat("coreTemperature", this.getCoreTemperature());
        tag.putFloat("localTemperature", this.getLocalTemperature());
        return tag;
    }

    @Override
    public ValueOutput write(ValueOutput valueOutput) {
        valueOutput.putFloat("skinTemperature", this.getSkinTemperature());
        valueOutput.putFloat("lastSkinTemperature", this.getLastSkinTemperature());
        valueOutput.putFloat("coreTemperature", this.getCoreTemperature());
        valueOutput.putFloat("localTemperature", this.getLocalTemperature());
        return valueOutput;
    }

    @Override
    public void read(CompoundTag tag) {
        this.setSkinTemperature(((Float)tag.getFloat("skinTemperature").orElseThrow()).floatValue());
        this.setLastSkinTemperature(((Float)tag.getFloat("lastSkinTemperature").orElseThrow()).floatValue());
        this.setCoreTemperature(((Float)tag.getFloat("coreTemperature").orElseThrow()).floatValue());
        this.setLocalTemperature(((Float)tag.getFloat("localTemperature").orElseThrow()).floatValue());
    }

    @Override
    public void read(ValueInput valueInput) {
        this.setSkinTemperature(valueInput.getFloatOr("skinTemperature", TemperatureThreshold.NORMAL.temperature));
        this.setLastSkinTemperature(valueInput.getFloatOr("lastSkinTemperature", TemperatureThreshold.NORMAL.temperature));
        this.setCoreTemperature(valueInput.getFloatOr("coreTemperature", TemperatureThreshold.NORMAL.temperature));
        this.setLocalTemperature(valueInput.getFloatOr("localTemperature", TemperatureRange.PARITY.temperature));
    }
}

