/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.wetness.WetnessInfo;
import homeostatic.network.IWetness;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public class Wetness
implements IWetness {
    private int wetnessLevel = 0;
    private float moistureLevel = 0.0f;

    @Override
    public void setWetnessLevel(int wetnessLevel) {
        this.wetnessLevel = wetnessLevel;
    }

    @Override
    public void setMoistureLevel(float moistureLevel) {
        this.moistureLevel = moistureLevel;
    }

    @Override
    public void setWetnessData(WetnessInfo wetnessInfo) {
        this.setWetnessLevel(wetnessInfo.getWetnessLevel());
        this.setMoistureLevel(wetnessInfo.getMoistureLevel());
    }

    @Override
    public int getWetnessLevel() {
        return this.wetnessLevel;
    }

    @Override
    public float getMoistureLevel() {
        return this.moistureLevel;
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        tag.putInt("wetnessLevel", this.getWetnessLevel());
        tag.putFloat("moistureLevel", this.getMoistureLevel());
        return tag;
    }

    @Override
    public ValueOutput write(@NotNull ValueOutput valueOutput) {
        valueOutput.putInt("wetnessLevel", this.getWetnessLevel());
        valueOutput.putFloat("moistureLevel", this.getMoistureLevel());
        return valueOutput;
    }

    @Override
    public void read(CompoundTag tag) {
        this.setWetnessLevel((Integer)tag.getInt("wetnessLevel").orElseThrow());
        this.setMoistureLevel(((Float)tag.getFloat("moistureLevel").orElseThrow()).floatValue());
    }

    @Override
    public void read(@NotNull ValueInput valueInput) {
        this.setWetnessLevel(valueInput.getIntOr("wetnessLevel", 0));
        this.setMoistureLevel(valueInput.getFloatOr("moistureLevel", 0.0f));
    }
}

