/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import homeostatic.Homeostatic;
import homeostatic.common.temperature.TemperatureRange;
import homeostatic.config.ConfigHandler;
import homeostatic.network.ITemperature;
import homeostatic.overlay.Overlay;
import homeostatic.platform.Services;
import homeostatic.util.Alignment;
import homeostatic.util.ColorHelper;
import homeostatic.util.FontHelper;
import homeostatic.util.TempHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class TemperatureGlobeOverlay
extends Overlay {
    public static final ResourceLocation SPRITE = Homeostatic.prefix("textures/gui/icons.png");
    protected static final int ICON_WIDTH = 18;
    protected static final int ICON_HEIGHT = 14;

    TemperatureGlobeOverlay() {
    }

    @Override
    public void render(GuiGraphics guiGraphics, Minecraft mc, @Nullable BlockPos pos, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.player;
        Matrix3x2fStack matrix = guiGraphics.pose();
        if (player == null) {
            return;
        }
        Services.PLATFORM.getTemperatureData((Player)player).ifPresent(arg_0 -> this.lambda$render$1(scaledWidth, scaledHeight, mc, guiGraphics, (Player)player, matrix, arg_0));
    }

    private int getTempOffset(Tuple<TemperatureRange, Integer> rangeStep) {
        TemperatureRange range = (TemperatureRange)((Object)rangeStep.getA());
        int step = (Integer)rangeStep.getB() / 2;
        int offset = range == TemperatureRange.COLD ? 120 + step * 15 : 120 - step * 15;
        return offset;
    }

    private /* synthetic */ void lambda$render$1(int scaledWidth, int scaledHeight, Minecraft mc, GuiGraphics guiGraphics, Player player, Matrix3x2fStack matrix, ITemperature data) {
        int offsetX = Alignment.getX(ConfigHandler.Client.globePosition(), scaledWidth, 18, ConfigHandler.Client.globeOffsetX());
        int pY = Alignment.getY(ConfigHandler.Client.globePosition(), scaledHeight, ConfigHandler.Client.globeOffsetY());
        float textScale = 0.5f;
        int textOffsetY = Alignment.getIconTextY(ConfigHandler.Client.globePosition(), scaledHeight, ConfigHandler.Client.globeTextOffsetY(), textScale);
        int pUOffset = 80;
        String coreTempFormat = ConfigHandler.Client.showDegreeSymbol() ? "%.1f\u00b0" : "%.1f";
        String localTempFormat = ConfigHandler.Client.showDegreeSymbol() ? "%.0f\u00b0" : "%.0f";
        String coreTempSmall = String.format(coreTempFormat, TempHelper.convertMcTemp(data.getCoreTemperature(), ConfigHandler.Client.useFahrenheit()));
        String localTemp = String.format(localTempFormat, TempHelper.convertMcTemp(data.getLocalTemperature(), ConfigHandler.Client.useFahrenheit()));
        AtomicBoolean showTemperature = new AtomicBoolean(ConfigHandler.Common.showTemperatureValues());
        int coreOffsetX = Alignment.getIconTextX(ConfigHandler.Client.globePosition(), scaledWidth, mc.font.width(coreTempSmall), ConfigHandler.Client.globeOffsetX(), textScale, 18);
        int localOffsetX = Alignment.getIconTextX(ConfigHandler.Client.globePosition(), scaledWidth, mc.font.width(localTemp), ConfigHandler.Client.globeOffsetX(), textScale, 18);
        Tuple<TemperatureRange, Integer> localRangeStep = TempHelper.getLocalTemperatureRangeStep(data.getLocalTemperature());
        Tuple<TemperatureRange, Integer> coreRangeStep = TempHelper.getBodyTemperatureRangeStep(data.getCoreTemperature());
        int pV = this.getTempOffset(coreRangeStep);
        int localPV = this.getTempOffset(localRangeStep);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, SPRITE, offsetX, pY, (float)pUOffset, (float)pV, 18, 14, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, SPRITE, offsetX, pY, (float)(pUOffset + 18), (float)localPV, 18, 14, 256, 256);
        if (ConfigHandler.Common.requireThermometer()) {
            Services.PLATFORM.getThermometerCapability(player).ifPresent(thermometer -> showTemperature.set(thermometer.hasThermometer()));
        }
        if (showTemperature.get()) {
            matrix.scale(textScale, textScale);
            FontHelper.draw(mc, guiGraphics, localTemp, localOffsetX - 1, textOffsetY - 19, ColorHelper.getLocalTemperatureColor(localRangeStep), true);
            FontHelper.draw(mc, guiGraphics, coreTempSmall, coreOffsetX - 1, textOffsetY, ColorHelper.getGlobeTemperatureColor(coreRangeStep), true);
        }
    }
}

