/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import homeostatic.common.TagManager;
import homeostatic.common.component.HomeostaticComponents;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.platform.Services;
import homeostatic.util.IngredientHelper;
import homeostatic.util.WaterHelper;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GuidebookHelper {
    public static Recipe<?> getRecipe(Level level, ResourceLocation loc) {
        Ingredient ingredient = null;
        ItemStack armorStackBase = null;
        ItemStack armorStack = null;
        ItemStack leatherFlaskBase = null;
        ItemStack leatherFlask = null;
        ShapelessRecipe customRecipe = null;
        boolean removalRecipe = false;
        if (loc != null && level != null) {
            String recipe;
            switch (recipe = loc.getPath()) {
                case "insulation": {
                    ingredient = IngredientHelper.fromTag(TagManager.Items.INSULATION);
                    armorStackBase = new ItemStack((ItemLike)Items.LEATHER_BOOTS);
                    armorStack = armorStackBase.copy();
                    CompoundTag armorStackTag = ((CustomData)armorStack.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
                    armorStackTag.putBoolean("insulation", true);
                    armorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)armorStackTag));
                    break;
                }
                case "remove_insulation": {
                    ingredient = Ingredient.of((ItemLike)Items.SHEARS);
                    armorStackBase = new ItemStack((ItemLike)Items.LEATHER_BOOTS);
                    armorStack = armorStackBase.copy();
                    CompoundTag armorStackTag = ((CustomData)armorStackBase.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
                    armorStackTag.putBoolean("insulation", true);
                    armorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)armorStackTag));
                    removalRecipe = true;
                    break;
                }
                case "waterproof": {
                    ingredient = IngredientHelper.fromTag(TagManager.Items.WATERPROOF);
                    armorStackBase = new ItemStack((ItemLike)Items.LEATHER_HELMET);
                    armorStack = armorStackBase.copy();
                    CompoundTag armorStackTag = ((CustomData)armorStack.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
                    armorStackTag.putBoolean("waterproof", true);
                    armorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)armorStackTag));
                    break;
                }
                case "remove_waterproof": {
                    ingredient = Ingredient.of((ItemLike)Items.LAVA_BUCKET);
                    armorStackBase = new ItemStack((ItemLike)Items.LEATHER_HELMET);
                    armorStack = armorStackBase.copy();
                    CompoundTag armorStackTag = ((CustomData)armorStackBase.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
                    armorStackTag.putBoolean("waterproof", true);
                    armorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)armorStackTag));
                    removalRecipe = true;
                    break;
                }
                case "radiation_protection": {
                    ingredient = IngredientHelper.fromTag(TagManager.Items.RADIATION_PROTECTION);
                    armorStackBase = new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE);
                    armorStack = armorStackBase.copy();
                    CompoundTag armorStackTag = ((CustomData)armorStack.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
                    armorStackTag.putBoolean("radiation_protection", true);
                    armorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)armorStackTag));
                    break;
                }
                case "remove_radiation_protection": {
                    ingredient = Ingredient.of((ItemLike)Items.WATER_BUCKET);
                    armorStackBase = new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE);
                    armorStack = armorStackBase.copy();
                    CompoundTag armorStackTag = ((CustomData)armorStackBase.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
                    armorStackTag.putBoolean("radiation_protection", true);
                    armorStack.set(HomeostaticComponents.ARMOR, (Object)CustomData.of((CompoundTag)armorStackTag));
                    removalRecipe = true;
                    break;
                }
                case "filtered_water_flask": {
                    ingredient = Ingredient.of((ItemLike)HomeostaticItems.WATER_FILTER);
                    leatherFlaskBase = new ItemStack((ItemLike)HomeostaticItems.LEATHER_FLASK);
                    leatherFlask = WaterHelper.getFilledItem(leatherFlaskBase, HomeostaticFluids.PURIFIED_WATER, (int)Services.PLATFORM.getFluidCapacity(leatherFlaskBase));
                }
            }
            if (armorStackBase != null) {
                Ingredient baseArmorIngredient = Ingredient.of((ItemLike)armorStackBase.getItem());
                NonNullList armorInputs = removalRecipe ? NonNullList.of(null, (Object[])new Ingredient[]{baseArmorIngredient, ingredient}) : NonNullList.of(null, (Object[])new Ingredient[]{baseArmorIngredient, ingredient, ingredient, ingredient});
                customRecipe = new ShapelessRecipe("armor.enhancement", CraftingBookCategory.EQUIPMENT, armorStack, (List)armorInputs);
            } else if (leatherFlask != null) {
                Ingredient baseFlaskIngredient = Ingredient.of((ItemLike)leatherFlaskBase.getItem());
                NonNullList recipeInputs = NonNullList.of(null, (Object[])new Ingredient[]{baseFlaskIngredient, ingredient});
                customRecipe = new ShapelessRecipe("flask.filter", CraftingBookCategory.MISC, leatherFlask, (List)recipeInputs);
            }
        }
        return customRecipe;
    }
}

