/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.biome;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.biome.BiomeCategory;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.biome.Biome;

public class BiomeCategoryManager
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, BiomeCategory> BIOME_CATEGORIES = new HashMap<ResourceLocation, BiomeCategory>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BiomeCategory.class, (Object)new BiomeCategory.Serializer()).create();

    public BiomeCategoryManager() {
        super(GSON, "environment/biome_category");
    }

    public static JsonElement parseBiomeCategory(BiomeCategory biomeCategory) {
        return GSON.toJsonTree((Object)biomeCategory);
    }

    public static BiomeCategory.Type getBiomeCategory(Holder<Biome> biome) {
        try {
            Optional key = biome.unwrapKey();
            BiomeCategory biomeCategory = key.isPresent() ? BIOME_CATEGORIES.getOrDefault(((ResourceKey)key.get()).location(), BiomeCategory.MISSING) : BiomeCategory.MISSING;
            return BiomeCategory.Type.valueOf(biomeCategory.type());
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            Homeostatic.LOGGER.debug("Unable to find biome for: {}", (Object)biome.toString());
            return BiomeCategory.Type.MISSING;
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        BIOME_CATEGORIES.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            try {
                BiomeCategory biomeCategory = (BiomeCategory)GSON.fromJson(entry.getValue(), BiomeCategory.class);
                BIOME_CATEGORIES.put(biomeCategory.loc(), biomeCategory);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse biome category {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded category for {} biomes.", (Object)BIOME_CATEGORIES.size());
    }
}

