/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.temperature;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import homeostatic.common.biome.BiomeTypeData;
import homeostatic.common.biome.BiomeTypeDataManager;
import homeostatic.common.biome.ClimateSettings;
import homeostatic.common.temperature.Environment;
import homeostatic.common.temperature.EnvironmentInfo;
import homeostatic.common.temperature.SubSeason;
import homeostatic.util.TempHelper;
import homeostatic.util.WetnessHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import technology.roughness.whitenoise.platform.Services;

public class EnvironmentData {
    private boolean isSubmerged;
    private boolean isPartialSubmersion;
    private double relativeHumidity;
    private float airTemperature;
    private float waterTemperature;
    private float localTemperature;
    private double envRadiation;
    private static final PerlinSimplexNoise TEMPERATURE_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(1234L)), (List)ImmutableList.of((Object)0));

    public EnvironmentData(ServerPlayer sp, BlockPos pos, Holder<Biome> biome, ServerLevel world) {
        LevelData info = world.getLevelData();
        ArrayList<Pair> biomes = new ArrayList<Pair>();
        int chunkRange = 3;
        float accumulatedDryTemp = 0.0f;
        float accumulatedHumidity = 0.0f;
        float moisture = 0.0f;
        EnvironmentInfo envData = Environment.get(world, sp);
        boolean isUnderground = envData.isUnderground();
        boolean isSheltered = envData.isSheltered();
        double waterVolume = envData.getWaterVolume();
        Holder.Reference lushBiome = world.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(Biomes.LUSH_CAVES);
        this.envRadiation = envData.getRadiation();
        this.isPartialSubmersion = !sp.isUnderWater() && sp.isInWater() && sp.isInWaterRainOrBubble();
        boolean bl = this.isSubmerged = sp.isUnderWater() && sp.isInWater() && sp.isInWaterRainOrBubble();
        if (this.isSubmerged) {
            moisture = 20.0f;
        } else if (this.isPartialSubmersion) {
            moisture = 10.0f;
        } else if (sp.isInWaterRainOrBubble()) {
            moisture = 0.5f;
        }
        if (moisture > 0.0f) {
            WetnessHelper.updateWetnessInfo(sp, moisture, true);
        }
        if (!this.isPartialSubmersion && !sp.isPassenger()) {
            this.isPartialSubmersion = sp.getInBlockState().is(Blocks.WATER);
        }
        if (isSheltered || isUnderground) {
            biomes.add(Pair.of((Object)lushBiome, (Object)pos));
        }
        if (!isUnderground || this.isSubmerged) {
            for (int x = -chunkRange; x <= chunkRange; ++x) {
                for (int z = -chunkRange; z <= chunkRange; ++z) {
                    BlockPos chunkPos = pos.offset(x * 16, 0, z * 16);
                    if (!world.isLoaded(chunkPos)) continue;
                    biomes.add(Pair.of((Object)world.getBiome(chunkPos), (Object)chunkPos));
                }
            }
        }
        for (Pair pair : biomes) {
            Holder chunkBiome = (Holder)pair.getFirst();
            BlockPos chunkPos = (BlockPos)pair.getSecond();
            float chunkTemp = EnvironmentData.getHeightAdjustedTemperature(world, (Holder<Biome>)chunkBiome, chunkPos);
            accumulatedDryTemp += isUnderground ? chunkTemp : EnvironmentData.getSeasonAdjustedTemperature(world, (Holder<Biome>)chunkBiome, chunkTemp, chunkPos);
            if (!info.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE)) continue;
            double chunkHumidity = EnvironmentData.getBiomeHumidity(world, (Holder<Biome>)chunkBiome, chunkPos);
            accumulatedHumidity = (float)((double)accumulatedHumidity + chunkHumidity);
        }
        this.relativeHumidity = accumulatedHumidity / (float)biomes.size();
        float dayNightOffset = isUnderground ? 0.0f : EnvironmentData.getDayNightOffset(world, biome, this.relativeHumidity);
        float dryTemp = accumulatedDryTemp / (float)biomes.size() + dayNightOffset;
        float wetTemp = (float)TempHelper.getHeatIndex(dryTemp, this.relativeHumidity);
        float blackGlobeTemp = (float)this.getBlackGlobeTemp(world, pos, dryTemp, this.relativeHumidity);
        this.airTemperature = isSheltered || isUnderground ? wetTemp * 0.7f + blackGlobeTemp * 0.3f : wetTemp * 0.7f + blackGlobeTemp * 0.2f + dryTemp * 0.1f;
        if (this.isSubmerged || this.isPartialSubmersion) {
            this.waterTemperature = EnvironmentData.getWaterTemperature(this.airTemperature, waterVolume);
            this.localTemperature = this.isSubmerged ? this.waterTemperature : this.waterTemperature * 0.7f + this.airTemperature * 0.3f;
        } else {
            this.localTemperature = this.airTemperature;
        }
    }

    public boolean isSubmerged() {
        return this.isSubmerged;
    }

    public boolean isPartialSubmersion() {
        return this.isPartialSubmersion;
    }

    public double getRelativeHumidity() {
        return this.relativeHumidity;
    }

    public float getLocalTemperature() {
        return this.localTemperature;
    }

    public double getEnvRadiation() {
        return this.envRadiation;
    }

    private double getBlackGlobeTemp(ServerLevel world, BlockPos pos, float dryTemp, double relativeHumidity) {
        this.envRadiation += EnvironmentData.getSunRadiation(world, pos);
        return TempHelper.getBlackGlobe(this.envRadiation, dryTemp, relativeHumidity);
    }

    private static double getBiomeHumidity(ServerLevel level, Holder<Biome> biomeHolder, BlockPos pos) {
        double biomeHumidity;
        LevelData info = level.getLevelData();
        Biome biome = (Biome)biomeHolder.value();
        ServerLevelData serverInfo = homeostatic.platform.Services.PLATFORM.getServerLevelData(level);
        double maxRH = EnvironmentData.getMaxBiomeHumidity(biomeHolder, pos);
        double minRH = maxRH - 20.0;
        if (biome.hasPrecipitation()) {
            int nextRain = serverInfo.getClearWeatherTime();
            biomeHumidity = info.isRaining() ? maxRH : (nextRain > 0 && nextRain <= 12000 ? minRH + (double)(20.0f * (1.0f - (float)nextRain / 12000.0f)) : minRH);
        } else {
            biomeHumidity = minRH;
        }
        return biomeHumidity;
    }

    private static double getSunRadiation(ServerLevel world, BlockPos pos) {
        double radiation = 0.0;
        double sunlight = world.getBrightness(LightLayer.SKY, pos.above()) - world.getSkyDarken();
        float f = world.getSunAngle(1.0f);
        if (sunlight > 0.0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            sunlight *= (double)Mth.cos((float)f);
        }
        return Math.max(radiation += sunlight * 100.0, 0.0);
    }

    private static double getMaxBiomeHumidity(Holder<Biome> biomeHolder, BlockPos pos) {
        BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome(biomeHolder);
        return biomeTypeData.getHumidity(((Biome)biomeHolder.value()).getPrecipitationAt(pos));
    }

    private static float getWaterTemperature(float airTemperature, double waterVolume) {
        float waterTemp;
        float baseWaterTemp = 0.663f;
        if (airTemperature >= Environment.PARITY) {
            float increase = 0.1f + (float)(1.0 - waterVolume) * 0.35f;
            waterTemp = baseWaterTemp + (airTemperature - Environment.PARITY) * increase;
        } else {
            waterTemp = Math.max(baseWaterTemp - (Environment.PARITY - airTemperature) * 0.5f, 0.072f);
        }
        return waterTemp;
    }

    private static float getDayNightOffset(ServerLevel world, Holder<Biome> biome, double relativeHumidity) {
        ResourceKey worldKey = world.dimension();
        if (!worldKey.location().toString().contains(BuiltinDimensionTypes.OVERWORLD.location().toString())) {
            return 0.0f;
        }
        BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome(biome);
        long time = world.getDayTime() % 24000L;
        ClimateSettings climateSettings = homeostatic.platform.Services.PLATFORM.getClimateSettings(biome);
        float maxTemp = biomeTypeData.getDayNightOffset(climateSettings.getPrecipitationType());
        if (maxTemp == 0.0f) {
            return maxTemp;
        }
        float increaseTemp = maxTemp / 10000.0f;
        float decreaseTemp = maxTemp / 14000.0f;
        float humidityOffset = 1.0f - (float)(relativeHumidity / 100.0);
        float offset = time > 23000L ? (float)(24001L - time) * increaseTemp : (time < 9001L ? (float)(time + 1000L) * increaseTemp : maxTemp - (float)(time - 9000L) * decreaseTemp);
        return offset * humidityOffset;
    }

    private static float getHeightAdjustedTemperature(ServerLevel world, Holder<Biome> biomeHolder, BlockPos pos) {
        ResourceKey worldKey = world.dimension();
        BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome(biomeHolder);
        Biome.Precipitation precipitation = ((Biome)biomeHolder.value()).getPrecipitationAt(pos);
        float temperature = biomeTypeData.getTemperature(precipitation);
        if (!worldKey.location().toString().contains(BuiltinDimensionTypes.OVERWORLD.location().toString())) {
            return temperature;
        }
        if (Services.PLATFORM.isModLoaded("primalwinter") && precipitation != Biome.Precipitation.SNOW) {
            temperature += -0.446f;
        }
        if (pos.getY() > 80) {
            float noise = (float)(TEMPERATURE_NOISE.getValue((double)((float)pos.getX() / 8.0f), (double)((float)pos.getZ() / 8.0f), false) * 8.0);
            return temperature - (noise + EnvironmentData.getAdjustedHeight(world, pos.getY()) - 80.0f) * 0.05f / 40.0f;
        }
        return temperature;
    }

    private static float getAdjustedHeight(ServerLevel world, float y) {
        return y / ((float)world.getMaxBuildHeight() / 256.0f);
    }

    private static float getSeasonAdjustedTemperature(ServerLevel level, Holder<Biome> biomeHolder, float biomeTemp, BlockPos pos) {
        ResourceKey worldKey = level.dimension();
        if (!worldKey.location().toString().contains(BuiltinDimensionTypes.OVERWORLD.location().toString())) {
            return biomeTemp;
        }
        BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome(biomeHolder);
        SubSeason subSeasonHolder = homeostatic.platform.Services.PLATFORM.getSubSeason(level, biomeHolder);
        if (subSeasonHolder != null) {
            float lateSummerOffset = 0.022289157f * 5.0f;
            int subSeason = subSeasonHolder.ordinal();
            float variation = biomeTypeData.getSeasonVariation(((Biome)biomeHolder.value()).getPrecipitationAt(pos)) / 2.0f;
            int season = subSeason + 9 <= 12 ? subSeason + 9 : subSeason - 3;
            double temp = EnvironmentData.getSeasonTemperature(season, variation, biomeTemp);
            if (season == 2) {
                temp += (double)lateSummerOffset;
            }
            return (float)temp;
        }
        if (Services.PLATFORM.isModLoaded("primalwinter")) {
            int season = 7;
            float variation = biomeTypeData.getSeasonVariation(Biome.Precipitation.RAIN);
            double temp = EnvironmentData.getSeasonTemperature(season, variation, biomeTemp);
            return (float)temp;
        }
        return biomeTemp;
    }

    private static double getSeasonTemperature(int season, float variation, float biomeTemp) {
        return (double)variation * Math.cos((double)(season - 1) * Math.PI / 6.0) + (double)biomeTemp;
    }

    public String toString() {
        return "EnvironmentData{isSubmerged=" + this.isSubmerged + ", isPartialSubmersion=" + this.isPartialSubmersion + ", relativeHumidity=" + this.relativeHumidity + ", airTemperature=" + this.airTemperature + ", waterTemperature=" + this.waterTemperature + ", localTemperature=" + this.localTemperature + ", envRadiation=" + this.envRadiation + "}";
    }
}

