/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.event;

import homeostatic.common.component.HomeostaticComponents;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.EnvironmentData;
import homeostatic.common.temperature.ThermometerInfo;
import homeostatic.common.water.WaterInfo;
import homeostatic.config.ConfigHandler;
import homeostatic.network.ITemperature;
import homeostatic.network.Temperature;
import homeostatic.platform.Services;
import homeostatic.util.GameModeHelper;
import homeostatic.util.WaterHelper;
import homeostatic.util.WetnessHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;

public class PlayerEventHandler {
    public static void onEntityJoinLevel(ServerPlayer sp) {
        ServerLevel world = sp.serverLevel();
        if (!GameModeHelper.shouldLoad(sp)) {
            return;
        }
        WaterHelper.updateWaterInfo(sp, 0.0f);
        WetnessHelper.updateWetnessInfo(sp, 0.0f, true);
        Services.PLATFORM.getTemperatureData((Player)sp).ifPresent(data -> {
            Vec3 spPos = sp.getEyePosition(1.0f);
            BlockPos pos = new BlockPos((int)spPos.x(), (int)spPos.y(), (int)spPos.z());
            Holder biome = world.getBiome(pos);
            EnvironmentData environmentData = new EnvironmentData(sp, pos, (Holder<Biome>)biome, world);
            BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, (ITemperature)data);
            Services.PLATFORM.syncTemperatureData(sp, environmentData, bodyTemperature);
        });
    }

    public static void onPlayerTickEvent(ServerPlayer sp) {
        if (!GameModeHelper.shouldLoad(sp)) {
            return;
        }
        ServerLevel world = sp.serverLevel();
        ProfilerFiller profilerfiller = world.getProfiler();
        Services.PLATFORM.getWaterCapabilty((Player)sp).ifPresent(data -> data.checkWaterLevel(sp));
        profilerfiller.push("tempCalc");
        Services.PLATFORM.getTemperatureData((Player)sp).ifPresent(data -> {
            if (sp.tickCount % 2 == 0) {
                data.checkTemperatureLevel((Player)sp);
            }
            if (sp.tickCount % 16 == 0 || sp.tickCount % 60 == 0) {
                Vec3 spPos = sp.getEyePosition(1.0f);
                BlockPos pos = new BlockPos((int)spPos.x(), (int)spPos.y(), (int)spPos.z());
                Holder biome = world.getBiome(pos);
                EnvironmentData environmentData = new EnvironmentData(sp, pos, (Holder<Biome>)biome, world);
                boolean updateCore = sp.tickCount % 60 == 0;
                BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, (ITemperature)data, updateCore, true);
                data.setTemperatureData(environmentData.getLocalTemperature(), bodyTemperature);
                Services.PLATFORM.syncTemperatureData(sp, environmentData, bodyTemperature);
            }
        });
        profilerfiller.pop();
    }

    public static void onPlayerRespawn(ServerPlayer sp) {
        ServerLevel world = sp.serverLevel();
        if (!GameModeHelper.shouldLoad(sp)) {
            return;
        }
        Services.PLATFORM.getWaterCapabilty((Player)sp).ifPresent(data -> {
            WaterInfo waterInfo = new WaterInfo(10, 2.5f, 0.0f);
            data.setWaterData(waterInfo);
            Services.PLATFORM.syncWaterData(sp, waterInfo);
        });
        Services.PLATFORM.getTemperatureData((Player)sp).ifPresent(data -> {
            Vec3 spPos = sp.getEyePosition(1.0f);
            BlockPos pos = new BlockPos((int)spPos.x(), (int)spPos.y(), (int)spPos.z());
            Holder biome = world.getBiome(pos);
            EnvironmentData environmentData = new EnvironmentData(sp, pos, (Holder<Biome>)biome, world);
            BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, new Temperature());
            data.setTemperatureData(environmentData.getLocalTemperature(), bodyTemperature);
            Services.PLATFORM.syncTemperatureData(sp, environmentData, bodyTemperature);
        });
    }

    public static void onEquipmentChange(LivingEntity entity, EquipmentSlot slot, ItemStack previousItem, ItemStack equippedItem) {
        if (ConfigHandler.Common.showTemperatureValues() && ConfigHandler.Common.requireThermometer() && slot == EquipmentSlot.HEAD && entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.level().isClientSide) {
                ServerPlayer sp = (ServerPlayer)player;
                if (!GameModeHelper.shouldLoad(sp)) {
                    return;
                }
                Services.PLATFORM.getThermometerCapability((Player)sp).ifPresent(data -> {
                    boolean equippedHasThermometer = PlayerEventHandler.hasThermometer(equippedItem);
                    ThermometerInfo info = new ThermometerInfo(equippedHasThermometer);
                    data.setHasThermometer(equippedHasThermometer);
                    Services.PLATFORM.syncThermometerData(sp, info);
                });
            }
        }
    }

    private static boolean hasThermometer(ItemStack helmet) {
        CompoundTag tag = ((CustomData)helmet.getOrDefault(HomeostaticComponents.ARMOR, (Object)CustomData.EMPTY)).copyTag();
        return tag.contains("thermometer");
    }
}

