/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.integrations.jei;

import homeostatic.Homeostatic;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.recipe.ArmorEnhancement;
import homeostatic.common.recipe.CampfirePurifiedLeatherFlask;
import homeostatic.common.recipe.CampfirePurifiedWaterBottle;
import homeostatic.common.recipe.HelmetThermometer;
import homeostatic.common.recipe.SmeltingPurifiedLeatherFlask;
import homeostatic.common.recipe.SmeltingPurifiedWaterBottle;
import homeostatic.common.recipe.SmokingPurifiedLeatherFlask;
import homeostatic.common.recipe.SmokingPurifiedWaterBottle;
import homeostatic.config.ConfigHandler;
import homeostatic.integrations.ArmorEnhancementRecipeMaker;
import homeostatic.integrations.CampfireRecipeMaker;
import homeostatic.integrations.HelmetThermometerRecipeMaker;
import homeostatic.integrations.SmeltingRecipeMaker;
import homeostatic.integrations.SmokerRecipeMaker;
import homeostatic.integrations.WaterFilterRecipeMaker;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return Homeostatic.prefix("jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Minecraft minecraft = Minecraft.getInstance();
        RecipeManager recipeManager = Objects.requireNonNull(minecraft.level).getRecipeManager();
        List allCraftingRecipes = recipeManager.getAllRecipesFor(RecipeType.CRAFTING);
        List<RecipeHolder<CraftingRecipe>> armorEnhancementRecipes = JEIPlugin.addArmorCraftingRecipes(allCraftingRecipes);
        List allCampfireRecipes = recipeManager.getAllRecipesFor(RecipeType.CAMPFIRE_COOKING);
        List<RecipeHolder<CampfireCookingRecipe>> purifiedWaterCampfireRecipes = JEIPlugin.addCampfireRecipes(allCampfireRecipes);
        List allSmokingRecipes = recipeManager.getAllRecipesFor(RecipeType.SMOKING);
        List<RecipeHolder<SmokingRecipe>> purifiedWaterSmokingRecipes = JEIPlugin.addSmokingRecipes(allSmokingRecipes);
        List allSmeltingRecipes = recipeManager.getAllRecipesFor(RecipeType.SMELTING);
        List<RecipeHolder<SmeltingRecipe>> purifiedWaterSmeltingRecipes = JEIPlugin.addSmeltingRecipes(allSmeltingRecipes);
        registration.addRecipes(RecipeTypes.CRAFTING, armorEnhancementRecipes);
        registration.addRecipes(RecipeTypes.CRAFTING, WaterFilterRecipeMaker.getFilterCraftingRecipes("jei"));
        registration.addRecipes(RecipeTypes.CAMPFIRE_COOKING, purifiedWaterCampfireRecipes);
        registration.addRecipes(RecipeTypes.SMOKING, purifiedWaterSmokingRecipes);
        registration.addRecipes(RecipeTypes.SMELTING, purifiedWaterSmeltingRecipes);
        if (!ConfigHandler.Common.requireThermometer()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)HomeostaticItems.THERMOMETER)));
        }
    }

    private static List<RecipeHolder<CraftingRecipe>> addArmorCraftingRecipes(List<RecipeHolder<CraftingRecipe>> allCraftingRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(ArmorEnhancement.class, () -> ArmorEnhancementRecipeMaker.createRecipes("jei"));
        if (ConfigHandler.Common.requireThermometer()) {
            replacers.put(HelmetThermometer.class, () -> HelmetThermometerRecipeMaker.createRecipes("jei"));
        }
        return allCraftingRecipes.stream().map(RecipeHolder::value).map(CraftingRecipe::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                List results = (List)supplier.get();
                return results.stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new RecipeHolder[0]);
            }
        }).toList();
    }

    private static List<RecipeHolder<CampfireCookingRecipe>> addCampfireRecipes(List<RecipeHolder<CampfireCookingRecipe>> allCraftingRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(CampfirePurifiedLeatherFlask.class, () -> CampfireRecipeMaker.createFlaskRecipes("jei"));
        replacers.put(CampfirePurifiedWaterBottle.class, () -> CampfireRecipeMaker.createWaterBottleRecipes("jei"));
        return allCraftingRecipes.stream().map(RecipeHolder::value).map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                List results = (List)supplier.get();
                return results.stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new RecipeHolder[0]);
            }
        }).toList();
    }

    private static List<RecipeHolder<SmokingRecipe>> addSmokingRecipes(List<RecipeHolder<SmokingRecipe>> allCraftingRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(SmokingPurifiedLeatherFlask.class, () -> SmokerRecipeMaker.createFlaskRecipes("jei"));
        replacers.put(SmokingPurifiedWaterBottle.class, () -> SmokerRecipeMaker.createWaterBottleRecipes("jei"));
        return allCraftingRecipes.stream().map(RecipeHolder::value).map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                List results = (List)supplier.get();
                return results.stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new RecipeHolder[0]);
            }
        }).toList();
    }

    private static List<RecipeHolder<SmeltingRecipe>> addSmeltingRecipes(List<RecipeHolder<SmeltingRecipe>> allCraftingRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(SmeltingPurifiedLeatherFlask.class, () -> SmeltingRecipeMaker.createFlaskRecipes("jei"));
        replacers.put(SmeltingPurifiedWaterBottle.class, () -> SmeltingRecipeMaker.createWaterBottleRecipes("jei"));
        return allCraftingRecipes.stream().map(RecipeHolder::value).map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                List results = (List)supplier.get();
                return results.stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new RecipeHolder[0]);
            }
        }).toList();
    }
}

